<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emails ServiceType
 * @subpackage Services
 */
class Emails extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * EmailsTableauDEtablissementsOrigine
     * Meta information extracted from the WSDL
     * - documentation: E-mail des établissements d'origine dont le nom est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauChaines $aTableau
     * @return \hp_\StructType\THpSvcWTableauChaines|bool
     */
    public function EmailsTableauDEtablissementsOrigine(\hp_\StructType\THpSvcWTableauChaines $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->EmailsTableauDEtablissementsOrigine($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\StructType\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
