<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Departement ServiceType
 * @subpackage Services
 */
class Departement extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DepartementObtentionBacEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Code du département d'obtention du baccalauréat de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function DepartementObtentionBacEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->DepartementObtentionBacEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DepartementObtentionBacTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Code du département d'obtention du baccalauréat des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauChaines|bool
     */
    public function DepartementObtentionBacTableauDEtudiants(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->DepartementObtentionBacTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\hp_\StructType\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
