<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Autorisation ServiceType
 * @subpackage Services
 */
class Autorisation extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AutorisationReceptionSMSEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Vrai si l'étudiant accepte de recevoir des SMS, faux sinon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return boolean|bool
     */
    public function AutorisationReceptionSMSEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->AutorisationReceptionSMSEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AutorisationDiffusionPhotoEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Vrai si l'étudiant de clé 'AEtudiant' autorise la diffusion de sa photo, faux sinon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return boolean|bool
     */
    public function AutorisationDiffusionPhotoEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->AutorisationDiffusionPhotoEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AutorisationDiffusionPhotoTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Tableau de booléens indiquant si les étudiants dont la clé est dans 'ATableau' autorisent la diffusion de leur photo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauBooleens|bool
     */
    public function AutorisationDiffusionPhotoTableauDEtudiants(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->AutorisationDiffusionPhotoTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|\hp_\StructType\THpSvcWTableauBooleens
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
