<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ajouter ServiceType
 * @subpackage Services
 */
class Ajouter extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AjouterEtudiantALaPromotion
     * Meta information extracted from the WSDL
     * - documentation: Affecte l'étudiant de clé 'AEtudiant' à la promotion de clé 'APromotion' sur l'année
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPromotion
     * @return void|bool
     */
    public function AjouterEtudiantALaPromotion($aEtudiant, $aPromotion)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterEtudiantALaPromotion($aEtudiant, $aPromotion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterEtudiantALaPromotionALaDate
     * Meta information extracted from the WSDL
     * - documentation: Affecte l'étudiant de clé 'AEtudiant' à la promotion de clé 'APromotion' à partir de la date 'ADate'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPromotion
     * @param string $aDate
     * @return void|bool
     */
    public function AjouterEtudiantALaPromotionALaDate($aEtudiant, $aPromotion, $aDate)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterEtudiantALaPromotionALaDate($aEtudiant, $aPromotion, $aDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterEtudiantATDOption
     * Meta information extracted from the WSDL
     * - documentation: Affecte l'étudiant de clé 'AEtudiant' au TD/Option de clé 'ATDOption' sur l'année. Rien ne se produit si l'étudiant a déjà ce TD ou cette option
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aTDOption
     * @return void|bool
     */
    public function AjouterEtudiantATDOption($aEtudiant, $aTDOption)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterEtudiantATDOption($aEtudiant, $aTDOption));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AjouterEtudiantATDOptionALaDate
     * Meta information extracted from the WSDL
     * - documentation: Affecte l'étudiant de clé 'AEtudiant' au TD/Option de clé 'ATDOption' à partir de la date 'ADate'. Rien ne se produit si l'étudiant a déjà ce TD ou cette option
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aTDOption
     * @param string $aDate
     * @return void|bool
     */
    public function AjouterEtudiantATDOptionALaDate($aEtudiant, $aTDOption, $aDate)
    {
        try {
            $this->setResult($this->getSoapClient()->AjouterEtudiantATDOptionALaDate($aEtudiant, $aTDOption, $aDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
