<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Trier ServiceType
 * @subpackage Services
 */
class Trier extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TrierTableauDEtudiantsParCle
     * Meta information extracted from the WSDL
     * - documentation: Trie le tableau 'ATableau' suivant la clé des étudiants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants|bool
     */
    public function TrierTableauDEtudiantsParCle(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->TrierTableauDEtudiantsParCle($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * TrierTableauDEtudiantsParNomPrenomEtDateDeNaissance
     * Meta information extracted from the WSDL
     * - documentation: Trie le tableau 'ATableau' suivant le nom, prénom et date de naissance des étudiants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants|bool
     */
    public function TrierTableauDEtudiantsParNomPrenomEtDateDeNaissance(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->TrierTableauDEtudiantsParNomPrenomEtDateDeNaissance($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * TrierTableauDEtudiantsParIdentifiant
     * Meta information extracted from the WSDL
     * - documentation: Trie le tableau 'ATableau' suivant l'identifiant des étudiants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants|bool
     */
    public function TrierTableauDEtudiantsParIdentifiant(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->TrierTableauDEtudiantsParIdentifiant($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\StructType\THpSvcWTableauClesEtudiants
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
