<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Promotions ServiceType
 * @subpackage Services
 */
class Promotions extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PromotionsEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés des promotions de l'étudiant de clé 'AEtudiant' à la date d'aujourd'hui
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return \hp_\StructType\THpSvcWTableauClesPromotions|bool
     */
    public function PromotionsEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->PromotionsEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PromotionsEtudiantALaDate
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés des promotions de l'étudiant de clé 'AEtudiant' à la date 'ADate'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aDate
     * @return \hp_\StructType\THpSvcWTableauClesPromotions|bool
     */
    public function PromotionsEtudiantALaDate($aEtudiant, $aDate)
    {
        try {
            $this->setResult($this->getSoapClient()->PromotionsEtudiantALaDate($aEtudiant, $aDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PromotionsEtudiantEntre2Dates
     * Meta information extracted from the WSDL
     * - documentation: Clés des promotions où l'étudiant de clé 'AEtudiant' a été inscrit au moins un jour entre 'ADateDebut' et 'ADateFin'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aDateDebut
     * @param string $aDateFin
     * @return \hp_\StructType\THpSvcWTableauClesPromotions|bool
     */
    public function PromotionsEtudiantEntre2Dates($aEtudiant, $aDateDebut, $aDateFin)
    {
        try {
            $this->setResult($this->getSoapClient()->PromotionsEtudiantEntre2Dates($aEtudiant, $aDateDebut, $aDateFin));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\StructType\THpSvcWTableauClesPromotions
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
