<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Promotion ServiceType
 * @subpackage Services
 */
class Promotion extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PromotionEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Clé de la promotion de l'étudiant de clé 'AEtudiant' à la date d'aujourd'hui. Échoue si l'étudiant spécifié est dans plusieurs promotions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return THpSvcWClePromotion|bool
     */
    public function PromotionEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->PromotionEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return THpSvcWClePromotion
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
