<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Niveau ServiceType
 * @subpackage Services
 */
class Niveau extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NiveauDansDiplomeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Niveau dans le diplôme atteint par l'étudiant de clé 'AEtudiant' le 15 janvier de l'année en cours
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function NiveauDansDiplomeEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->NiveauDansDiplomeEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NiveauDansDiplomeTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Niveau dans le diplôme atteint par les étudiants dont la clé est dans 'ATableau' le 15 janvier de l'année en cours
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauChaines|bool
     */
    public function NiveauDansDiplomeTableauDEtudiants(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->NiveauDansDiplomeTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\hp_\StructType\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
