<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lieux ServiceType
 * @subpackage Services
 */
class Lieux extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LieuxDeNaissanceTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Lieu de naissance des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauChaines|bool
     */
    public function LieuxDeNaissanceTableauDEtudiants(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->LieuxDeNaissanceTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\StructType\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
