<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for LE ServiceType
 * @subpackage Services
 */
class LE extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LEtudiantEstRedoublant
     * Meta information extracted from the WSDL
     * - documentation: Vrai si l'étudiant de clé 'AEtudiant' est redoublant, faux sinon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return boolean|bool
     */
    public function LEtudiantEstRedoublant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->LEtudiantEstRedoublant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
