<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Date ServiceType
 * @subpackage Services
 */
class Date extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DateDeNaissanceEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Date de naissance de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return date|bool
     */
    public function DateDeNaissanceEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->DateDeNaissanceEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DateInscriptionEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Date d'inscription de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return date|bool
     */
    public function DateInscriptionEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->DateInscriptionEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return date
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
