<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cours ServiceType
 * @subpackage Services
 */
class Cours extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CoursEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Clés des cours de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return \hp_\StructType\THpSvcWTableauClesCours|bool
     */
    public function CoursEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->CoursEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CoursEtudiantEntre2Dates
     * Meta information extracted from the WSDL
     * - documentation: Clés des cours de l'étudiant de clé 'AEtudiant' situées entre 'ADate1' et 'ADate2'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aDate1
     * @param string $aDate2
     * @return \hp_\StructType\THpSvcWTableauClesCours|bool
     */
    public function CoursEtudiantEntre2Dates($aEtudiant, $aDate1, $aDate2)
    {
        try {
            $this->setResult($this->getSoapClient()->CoursEtudiantEntre2Dates($aEtudiant, $aDate1, $aDate2));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\StructType\THpSvcWTableauClesCours
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
