<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Baccalaureat ServiceType
 * @subpackage Services
 */
class Baccalaureat extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BaccalaureatEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Code du baccalauréat (ou équivalence) de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function BaccalaureatEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->BaccalaureatEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BaccalaureatTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Code du baccalauréat (ou équivalence) des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\StructType\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\StructType\THpSvcWTableauChaines|bool
     */
    public function BaccalaureatTableauDEtudiants(\hp_\StructType\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->BaccalaureatTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\hp_\StructType\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
