<?php

namespace hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Assurance ServiceType
 * @subpackage Services
 */
class Assurance extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * AssuranceResponsabiliteCivileEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Assurance responsabilité civile de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function AssuranceResponsabiliteCivileEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->AssuranceResponsabiliteCivileEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
