<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \hp_\ClassMap::get(),
);
/**
 * Samples for Cle ServiceType
 */
$cle = new \hp_\Cle($options);
/**
 * Sample call for CleEtudiantEstValide operation/method
 */
if ($cle->CleEtudiantEstValide($AEtudiant) !== false) {
    print_r($cle->getResult());
} else {
    print_r($cle->getLastError());
}
/**
 * Sample call for CleSecuriteSocialeEtudiant operation/method
 */
if ($cle->CleSecuriteSocialeEtudiant($AEtudiant) !== false) {
    print_r($cle->getResult());
} else {
    print_r($cle->getLastError());
}
/**
 * Samples for Cles ServiceType
 */
$cles = new \hp_\Cles($options);
/**
 * Sample call for ClesEtudiantsValidesTableauDEtudiants operation/method
 */
if ($cles->ClesEtudiantsValidesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($cles->getResult());
} else {
    print_r($cles->getLastError());
}
/**
 * Sample call for ClesEtudiantsInvalidesTableauDEtudiants operation/method
 */
if ($cles->ClesEtudiantsInvalidesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($cles->getResult());
} else {
    print_r($cles->getLastError());
}
/**
 * Sample call for ClesSecuriteSocialeTableauDEtudiants operation/method
 */
if ($cles->ClesSecuriteSocialeTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($cles->getResult());
} else {
    print_r($cles->getLastError());
}
/**
 * Samples for Nombre ServiceType
 */
$nombre = new \hp_\Nombre($options);
/**
 * Sample call for NombreEtudiants operation/method
 */
if ($nombre->NombreEtudiants() !== false) {
    print_r($nombre->getResult());
} else {
    print_r($nombre->getLastError());
}
/**
 * Samples for Tous ServiceType
 */
$tous = new \hp_\Tous($options);
/**
 * Sample call for TousLesEtudiants operation/method
 */
if ($tous->TousLesEtudiants() !== false) {
    print_r($tous->getResult());
} else {
    print_r($tous->getLastError());
}
/**
 * Sample call for TousLesEtablissementsOrigine operation/method
 */
if ($tous->TousLesEtablissementsOrigine() !== false) {
    print_r($tous->getResult());
} else {
    print_r($tous->getLastError());
}
/**
 * Samples for Creer ServiceType
 */
$creer = new \hp_\Creer($options);
/**
 * Sample call for CreerEtudiant operation/method
 */
if ($creer->CreerEtudiant($ANom, $APrenom, $ADateDeNaissance) !== false) {
    print_r($creer->getResult());
} else {
    print_r($creer->getLastError());
}
/**
 * Sample call for CreerEtudiantAvecNumeroINE operation/method
 */
if ($creer->CreerEtudiantAvecNumeroINE($ANom, $APrenom, $ADateDeNaissance, $ANumeroINE) !== false) {
    print_r($creer->getResult());
} else {
    print_r($creer->getLastError());
}
/**
 * Sample call for CreerEtudiantAvecIdentifiant operation/method
 */
if ($creer->CreerEtudiantAvecIdentifiant($ANom, $APrenom, $ADateDeNaissance, $AIdentifiant) !== false) {
    print_r($creer->getResult());
} else {
    print_r($creer->getLastError());
}
/**
 * Sample call for CreerEtudiantAvecNumeroINEEtIdentifiant operation/method
 */
if ($creer->CreerEtudiantAvecNumeroINEEtIdentifiant($ANom, $APrenom, $ADateDeNaissance, $ANumeroINE, $AIdentifiant) !== false) {
    print_r($creer->getResult());
} else {
    print_r($creer->getLastError());
}
/**
 * Sample call for CreerEtablissementOrigine operation/method
 */
if ($creer->CreerEtablissementOrigine($ANomEtablissement, $AEmailEtablissement) !== false) {
    print_r($creer->getResult());
} else {
    print_r($creer->getLastError());
}
/**
 * Samples for Supprimer ServiceType
 */
$supprimer = new \hp_\Supprimer($options);
/**
 * Sample call for SupprimerEtudiant operation/method
 */
if ($supprimer->SupprimerEtudiant($AEtudiant) !== false) {
    print_r($supprimer->getResult());
} else {
    print_r($supprimer->getLastError());
}
/**
 * Sample call for SupprimerTableauDEtudiants operation/method
 */
if ($supprimer->SupprimerTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($supprimer->getResult());
} else {
    print_r($supprimer->getLastError());
}
/**
 * Sample call for SupprimerEtablissementOrigine operation/method
 */
if ($supprimer->SupprimerEtablissementOrigine($ANomEtablissement) !== false) {
    print_r($supprimer->getResult());
} else {
    print_r($supprimer->getLastError());
}
/**
 * Sample call for SupprimerTableauDEtablissementsOrigine operation/method
 */
if ($supprimer->SupprimerTableauDEtablissementsOrigine(new \hp_\THpSvcWTableauChaines()) !== false) {
    print_r($supprimer->getResult());
} else {
    print_r($supprimer->getLastError());
}
/**
 * Samples for Acceder ServiceType
 */
$acceder = new \hp_\Acceder($options);
/**
 * Sample call for AccederEtudiantParNomPrenomDateDeNaissanceEtNumeroINE
 * operation/method
 */
if ($acceder->AccederEtudiantParNomPrenomDateDeNaissanceEtNumeroINE($ANom, $APrenom, $ADateDeNaissance, $ANumeroINE) !== false) {
    print_r($acceder->getResult());
} else {
    print_r($acceder->getLastError());
}
/**
 * Sample call for AccederEtudiantsParNomPrenomEtDateDeNaissance operation/method
 */
if ($acceder->AccederEtudiantsParNomPrenomEtDateDeNaissance($ANom, $APrenom, $ADateDeNaissance) !== false) {
    print_r($acceder->getResult());
} else {
    print_r($acceder->getLastError());
}
/**
 * Sample call for AccederEtudiantParIdentifiant operation/method
 */
if ($acceder->AccederEtudiantParIdentifiant($AIdentifiant) !== false) {
    print_r($acceder->getResult());
} else {
    print_r($acceder->getLastError());
}
/**
 * Sample call for AccederEtudiantParNumeroDOrdre operation/method
 */
if ($acceder->AccederEtudiantParNumeroDOrdre($ANumero) !== false) {
    print_r($acceder->getResult());
} else {
    print_r($acceder->getLastError());
}
/**
 * Sample call for AccederEtudiantParNumeroINE operation/method
 */
if ($acceder->AccederEtudiantParNumeroINE($ANumero) !== false) {
    print_r($acceder->getResult());
} else {
    print_r($acceder->getLastError());
}
/**
 * Samples for Nom ServiceType
 */
$nom = new \hp_\Nom($options);
/**
 * Sample call for NomEtudiant operation/method
 */
if ($nom->NomEtudiant($AEtudiant) !== false) {
    print_r($nom->getResult());
} else {
    print_r($nom->getLastError());
}
/**
 * Sample call for NomJeuneFilleEtudiant operation/method
 */
if ($nom->NomJeuneFilleEtudiant($AEtudiant) !== false) {
    print_r($nom->getResult());
} else {
    print_r($nom->getLastError());
}
/**
 * Sample call for NomBaccalaureatDeCode operation/method
 */
if ($nom->NomBaccalaureatDeCode($ACode) !== false) {
    print_r($nom->getResult());
} else {
    print_r($nom->getLastError());
}
/**
 * Sample call for NomSpecialiteBacDeCode operation/method
 */
if ($nom->NomSpecialiteBacDeCode($ACode) !== false) {
    print_r($nom->getResult());
} else {
    print_r($nom->getLastError());
}
/**
 * Sample call for NomDepartementDeCode operation/method
 */
if ($nom->NomDepartementDeCode($ACode) !== false) {
    print_r($nom->getResult());
} else {
    print_r($nom->getLastError());
}
/**
 * Sample call for NomTypeDernierDiplomeDeCode operation/method
 */
if ($nom->NomTypeDernierDiplomeDeCode($ACode) !== false) {
    print_r($nom->getResult());
} else {
    print_r($nom->getLastError());
}
/**
 * Samples for Modifier ServiceType
 */
$modifier = new \hp_\Modifier($options);
/**
 * Sample call for ModifierNomEtudiant operation/method
 */
if ($modifier->ModifierNomEtudiant($AEtudiant, $ANom) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierPrenomEtudiant operation/method
 */
if ($modifier->ModifierPrenomEtudiant($AEtudiant, $APrenom) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierPrenom2Etudiant operation/method
 */
if ($modifier->ModifierPrenom2Etudiant($AEtudiant, $APrenom2) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierPrenom3Etudiant operation/method
 */
if ($modifier->ModifierPrenom3Etudiant($AEtudiant, $APrenom3) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierPrenomUsageEtudiant operation/method
 */
if ($modifier->ModifierPrenomUsageEtudiant($AEtudiant, $APrenomUsage) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierDateDeNaissanceEtudiant operation/method
 */
if ($modifier->ModifierDateDeNaissanceEtudiant($AEtudiant, $ADateDeNaissance) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierCiviliteEtudiant operation/method
 */
if ($modifier->ModifierCiviliteEtudiant($AEtudiant, $ACivilite) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierIdentifiantEtudiant operation/method
 */
if ($modifier->ModifierIdentifiantEtudiant($AEtudiant, $AIdentifiant) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierIdentifiantCASEtudiant operation/method
 */
if ($modifier->ModifierIdentifiantCASEtudiant($AEtudiant, $AIdentifiant) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierIdentifiantConnexionEtudiant operation/method
 */
if ($modifier->ModifierIdentifiantConnexionEtudiant($AEtudiant, $AIdentifiant) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierMotDePasseEtudiant operation/method
 */
if ($modifier->ModifierMotDePasseEtudiant($AEtudiant, $AMotDePasse) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierEMailEtudiant operation/method
 */
if ($modifier->ModifierEMailEtudiant($AEtudiant, $AEMail) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierEstDestinataireCourriersAbsencesEtudiant
 * operation/method
 */
if ($modifier->ModifierEstDestinataireCourriersAbsencesEtudiant($AEtudiant, $AEstDestinataire) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierSexeEtudiant operation/method
 */
if ($modifier->ModifierSexeEtudiant($AEtudiant, $ASexe) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierNumeroINEEtudiant operation/method
 */
if ($modifier->ModifierNumeroINEEtudiant($AEtudiant, $ANumeroINE) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierNumeroDOrdreEtudiant operation/method
 */
if ($modifier->ModifierNumeroDOrdreEtudiant($AEtudiant, $ANumeroDOrdre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierNomJeuneFilleEtudiant operation/method
 */
if ($modifier->ModifierNomJeuneFilleEtudiant($AEtudiant, $ANomJeuneFille) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierLieuDeNaissanceEtudiant operation/method
 */
if ($modifier->ModifierLieuDeNaissanceEtudiant($AEtudiant, $AVille) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierNationaliteEtudiant operation/method
 */
if ($modifier->ModifierNationaliteEtudiant($AEtudiant, $ANationalite) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierNumeroSecuriteSocialeEtudiant operation/method
 */
if ($modifier->ModifierNumeroSecuriteSocialeEtudiant($AEtudiant, $ANumeroSS) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierCleSecuriteSocialeEtudiant operation/method
 */
if ($modifier->ModifierCleSecuriteSocialeEtudiant($AEtudiant, $ACleSS) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierMutuelleEtudiant operation/method
 */
if ($modifier->ModifierMutuelleEtudiant($AEtudiant, $AMutuelle) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierCotisationEtudiant operation/method
 */
if ($modifier->ModifierCotisationEtudiant($AEtudiant, $ACotisation) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierMotifNonCotisationEtudiant operation/method
 */
if ($modifier->ModifierMotifNonCotisationEtudiant($AEtudiant, $AMotif) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierAssuranceResponsabiliteCivileEtudiant operation/method
 */
if ($modifier->ModifierAssuranceResponsabiliteCivileEtudiant($AEtudiant, $AAssurance) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierNumeroContratEtudiant operation/method
 */
if ($modifier->ModifierNumeroContratEtudiant($AEtudiant, $ANumeroContrat) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierAutreInformationEtudiant operation/method
 */
if ($modifier->ModifierAutreInformationEtudiant($AEtudiant, $AAutreInformation) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierCommentaireEtudiant operation/method
 */
if ($modifier->ModifierCommentaireEtudiant($AEtudiant, $ACommentaire) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierCodeFiscalEtudiant operation/method
 */
if ($modifier->ModifierCodeFiscalEtudiant($AEtudiant, $ACodeFiscal) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierAdresse1Etudiant operation/method
 */
if ($modifier->ModifierAdresse1Etudiant($AEtudiant, $AAdresse1) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierAdresse2Etudiant operation/method
 */
if ($modifier->ModifierAdresse2Etudiant($AEtudiant, $AAdresse2) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierAdresse3Etudiant operation/method
 */
if ($modifier->ModifierAdresse3Etudiant($AEtudiant, $AAdresse3) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierAdresse4Etudiant operation/method
 */
if ($modifier->ModifierAdresse4Etudiant($AEtudiant, $AAdresse4) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierCodePostalEtudiant operation/method
 */
if ($modifier->ModifierCodePostalEtudiant($AEtudiant, $ACodePostal) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierVilleEtudiant operation/method
 */
if ($modifier->ModifierVilleEtudiant($AEtudiant, $AVille) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierPaysEtudiant operation/method
 */
if ($modifier->ModifierPaysEtudiant($AEtudiant, $APays) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierProvinceEtudiant operation/method
 */
if ($modifier->ModifierProvinceEtudiant($AEtudiant, $AProvince) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierTelephoneFixeEtudiant operation/method
 */
if ($modifier->ModifierTelephoneFixeEtudiant($AEtudiant, $ATelephoneFixe) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierIndicatifTelephoneFixeEtudiant operation/method
 */
if ($modifier->ModifierIndicatifTelephoneFixeEtudiant($AEtudiant, $AIndicatif) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierTelephonePortableEtudiant operation/method
 */
if ($modifier->ModifierTelephonePortableEtudiant($AEtudiant, $ATelephonePortable) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierIndicatifTelephonePortableEtudiant operation/method
 */
if ($modifier->ModifierIndicatifTelephonePortableEtudiant($AEtudiant, $AIndicatif) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierAutorisationReceptionSMSEtudiant operation/method
 */
if ($modifier->ModifierAutorisationReceptionSMSEtudiant($AEtudiant, $AAutorisationSMS) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRedoublantEtudiant operation/method
 */
if ($modifier->ModifierRedoublantEtudiant($AEtudiant, $ARedoublant) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierBaccalaureatEtudiant operation/method
 */
if ($modifier->ModifierBaccalaureatEtudiant($AEtudiant, $ACodeBaccalaureat) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierSpecialite1BacEtudiant operation/method
 */
if ($modifier->ModifierSpecialite1BacEtudiant($AEtudiant, $ACodeSpecialite1) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierSpecialite2BacEtudiant operation/method
 */
if ($modifier->ModifierSpecialite2BacEtudiant($AEtudiant, $ACodeSpecialite2) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierDepartementObtentionBacEtudiant operation/method
 */
if ($modifier->ModifierDepartementObtentionBacEtudiant($AEtudiant, $ACodeDepartementObt) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierAnneeObtentionBacEtudiant operation/method
 */
if ($modifier->ModifierAnneeObtentionBacEtudiant($AEtudiant, $AAnneeObt) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierNiveauDansDiplomeEtudiant operation/method
 */
if ($modifier->ModifierNiveauDansDiplomeEtudiant($AEtudiant, $ANiveau) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierTypeDernierDiplomeEtudiant operation/method
 */
if ($modifier->ModifierTypeDernierDiplomeEtudiant($AEtudiant, $ACodeTypeDernierDiplome) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierModaliteDAdmissionEtudiant operation/method
 */
if ($modifier->ModifierModaliteDAdmissionEtudiant($AEtudiant, $AModalite) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierEtablissementOrigineEtudiant operation/method
 */
if ($modifier->ModifierEtablissementOrigineEtudiant($AEtudiant, $ANomEtablissement) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierEmailEtablissementOrigine operation/method
 */
if ($modifier->ModifierEmailEtablissementOrigine($ANomEtablissement, $AEmailEtablissement) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierDateInscriptionEtudiant operation/method
 */
if ($modifier->ModifierDateInscriptionEtudiant($AEtudiant, $ADateInscription) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierCursusAnterieurEtudiant operation/method
 */
if ($modifier->ModifierCursusAnterieurEtudiant($AEtudiant, $ACursusAnterieur) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierProprietaireEtudiant operation/method
 */
if ($modifier->ModifierProprietaireEtudiant($AEtudiant, $ANomProprietaire, $APrenomProprietaire) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierPhotoEtudiant operation/method
 */
if ($modifier->ModifierPhotoEtudiant($AEtudiant, $AFormat, $APhoto) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierAutorisationDiffusionPhotoEtudiant operation/method
 */
if ($modifier->ModifierAutorisationDiffusionPhotoEtudiant($AEtudiant, $AAutorise) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierPromotionEtudiant operation/method
 */
if ($modifier->ModifierPromotionEtudiant($AEtudiant, $APromotion) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Samples for Noms ServiceType
 */
$noms = new \hp_\Noms($options);
/**
 * Sample call for NomsTableauDEtudiants operation/method
 */
if ($noms->NomsTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($noms->getResult());
} else {
    print_r($noms->getLastError());
}
/**
 * Sample call for NomsJeuneFilleTableauDEtudiants operation/method
 */
if ($noms->NomsJeuneFilleTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($noms->getResult());
} else {
    print_r($noms->getLastError());
}
/**
 * Samples for Prenom ServiceType
 */
$prenom = new \hp_\Prenom($options);
/**
 * Sample call for PrenomEtudiant operation/method
 */
if ($prenom->PrenomEtudiant($AEtudiant) !== false) {
    print_r($prenom->getResult());
} else {
    print_r($prenom->getLastError());
}
/**
 * Sample call for Prenom2Etudiant operation/method
 */
if ($prenom->Prenom2Etudiant($AEtudiant) !== false) {
    print_r($prenom->getResult());
} else {
    print_r($prenom->getLastError());
}
/**
 * Sample call for Prenom3Etudiant operation/method
 */
if ($prenom->Prenom3Etudiant($AEtudiant) !== false) {
    print_r($prenom->getResult());
} else {
    print_r($prenom->getLastError());
}
/**
 * Sample call for PrenomUsageEtudiant operation/method
 */
if ($prenom->PrenomUsageEtudiant($AEtudiant) !== false) {
    print_r($prenom->getResult());
} else {
    print_r($prenom->getLastError());
}
/**
 * Samples for Prenoms ServiceType
 */
$prenoms = new \hp_\Prenoms($options);
/**
 * Sample call for PrenomsTableauDEtudiants operation/method
 */
if ($prenoms->PrenomsTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($prenoms->getResult());
} else {
    print_r($prenoms->getLastError());
}
/**
 * Sample call for Prenoms2TableauDEtudiants operation/method
 */
if ($prenoms->Prenoms2TableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($prenoms->getResult());
} else {
    print_r($prenoms->getLastError());
}
/**
 * Sample call for Prenoms3TableauDEtudiants operation/method
 */
if ($prenoms->Prenoms3TableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($prenoms->getResult());
} else {
    print_r($prenoms->getLastError());
}
/**
 * Sample call for PrenomsUsageTableauDEtudiants operation/method
 */
if ($prenoms->PrenomsUsageTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($prenoms->getResult());
} else {
    print_r($prenoms->getLastError());
}
/**
 * Samples for Date ServiceType
 */
$date = new \hp_\Date($options);
/**
 * Sample call for DateDeNaissanceEtudiant operation/method
 */
if ($date->DateDeNaissanceEtudiant($AEtudiant) !== false) {
    print_r($date->getResult());
} else {
    print_r($date->getLastError());
}
/**
 * Sample call for DateInscriptionEtudiant operation/method
 */
if ($date->DateInscriptionEtudiant($AEtudiant) !== false) {
    print_r($date->getResult());
} else {
    print_r($date->getLastError());
}
/**
 * Samples for Dates ServiceType
 */
$dates = new \hp_\Dates($options);
/**
 * Sample call for DatesDeNaissancesTableauDEtudiants operation/method
 */
if ($dates->DatesDeNaissancesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($dates->getResult());
} else {
    print_r($dates->getLastError());
}
/**
 * Sample call for DatesInscriptionTableauDEtudiants operation/method
 */
if ($dates->DatesInscriptionTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($dates->getResult());
} else {
    print_r($dates->getLastError());
}
/**
 * Sample call for DatesAffectationEtudiantAPromotion operation/method
 */
if ($dates->DatesAffectationEtudiantAPromotion($AEtudiant, $APromotion) !== false) {
    print_r($dates->getResult());
} else {
    print_r($dates->getLastError());
}
/**
 * Sample call for DatesAffectationEtudiantAuTDOption operation/method
 */
if ($dates->DatesAffectationEtudiantAuTDOption($AEtudiant, $ATDOption) !== false) {
    print_r($dates->getResult());
} else {
    print_r($dates->getLastError());
}
/**
 * Samples for Aucune ServiceType
 */
$aucune = new \hp_\Aucune($options);
/**
 * Sample call for AucuneDateDeNaissance operation/method
 */
if ($aucune->AucuneDateDeNaissance() !== false) {
    print_r($aucune->getResult());
} else {
    print_r($aucune->getLastError());
}
/**
 * Samples for Civilite ServiceType
 */
$civilite = new \hp_\Civilite($options);
/**
 * Sample call for CiviliteEtudiant operation/method
 */
if ($civilite->CiviliteEtudiant($AEtudiant) !== false) {
    print_r($civilite->getResult());
} else {
    print_r($civilite->getLastError());
}
/**
 * Samples for Civilites ServiceType
 */
$civilites = new \hp_\Civilites($options);
/**
 * Sample call for CivilitesTableauDEtudiants operation/method
 */
if ($civilites->CivilitesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($civilites->getResult());
} else {
    print_r($civilites->getLastError());
}
/**
 * Samples for Identifiant ServiceType
 */
$identifiant = new \hp_\Identifiant($options);
/**
 * Sample call for IdentifiantEtudiant operation/method
 */
if ($identifiant->IdentifiantEtudiant($AEtudiant) !== false) {
    print_r($identifiant->getResult());
} else {
    print_r($identifiant->getLastError());
}
/**
 * Sample call for IdentifiantCASEtudiant operation/method
 */
if ($identifiant->IdentifiantCASEtudiant($AEtudiant) !== false) {
    print_r($identifiant->getResult());
} else {
    print_r($identifiant->getLastError());
}
/**
 * Sample call for IdentifiantConnexionEtudiant operation/method
 */
if ($identifiant->IdentifiantConnexionEtudiant($AEtudiant) !== false) {
    print_r($identifiant->getResult());
} else {
    print_r($identifiant->getLastError());
}
/**
 * Samples for Identifiants ServiceType
 */
$identifiants = new \hp_\Identifiants($options);
/**
 * Sample call for IdentifiantsTableauDEtudiants operation/method
 */
if ($identifiants->IdentifiantsTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($identifiants->getResult());
} else {
    print_r($identifiants->getLastError());
}
/**
 * Sample call for IdentifiantsCASTableauDEtudiants operation/method
 */
if ($identifiants->IdentifiantsCASTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($identifiants->getResult());
} else {
    print_r($identifiants->getLastError());
}
/**
 * Sample call for IdentifiantsConnexionTableauDEtudiants operation/method
 */
if ($identifiants->IdentifiantsConnexionTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($identifiants->getResult());
} else {
    print_r($identifiants->getLastError());
}
/**
 * Samples for EM ServiceType
 */
$eM = new \hp_\EM($options);
/**
 * Sample call for EMailEtudiant operation/method
 */
if ($eM->EMailEtudiant($AEtudiant) !== false) {
    print_r($eM->getResult());
} else {
    print_r($eM->getLastError());
}
/**
 * Sample call for EMailsTableauDEtudiants operation/method
 */
if ($eM->EMailsTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($eM->getResult());
} else {
    print_r($eM->getLastError());
}
/**
 * Samples for Est ServiceType
 */
$est = new \hp_\Est($options);
/**
 * Sample call for EstDestinataireCourriersAbsencesEtudiant operation/method
 */
if ($est->EstDestinataireCourriersAbsencesEtudiant($AEtudiant) !== false) {
    print_r($est->getResult());
} else {
    print_r($est->getLastError());
}
/**
 * Samples for Sont ServiceType
 */
$sont = new \hp_\Sont($options);
/**
 * Sample call for SontDestinatairesCourriersAbsencesTableauDEtudiants
 * operation/method
 */
if ($sont->SontDestinatairesCourriersAbsencesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($sont->getResult());
} else {
    print_r($sont->getLastError());
}
/**
 * Samples for Sexe ServiceType
 */
$sexe = new \hp_\Sexe($options);
/**
 * Sample call for SexeEtudiant operation/method
 */
if ($sexe->SexeEtudiant($AEtudiant) !== false) {
    print_r($sexe->getResult());
} else {
    print_r($sexe->getLastError());
}
/**
 * Samples for Sexes ServiceType
 */
$sexes = new \hp_\Sexes($options);
/**
 * Sample call for SexesTableauDEtudiants operation/method
 */
if ($sexes->SexesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($sexes->getResult());
} else {
    print_r($sexes->getLastError());
}
/**
 * Samples for Numero ServiceType
 */
$numero = new \hp_\Numero($options);
/**
 * Sample call for NumeroINEEtudiant operation/method
 */
if ($numero->NumeroINEEtudiant($AEtudiant) !== false) {
    print_r($numero->getResult());
} else {
    print_r($numero->getLastError());
}
/**
 * Sample call for NumeroDOrdreEtudiant operation/method
 */
if ($numero->NumeroDOrdreEtudiant($AEtudiant) !== false) {
    print_r($numero->getResult());
} else {
    print_r($numero->getLastError());
}
/**
 * Sample call for NumeroSecuriteSocialeEtudiant operation/method
 */
if ($numero->NumeroSecuriteSocialeEtudiant($AEtudiant) !== false) {
    print_r($numero->getResult());
} else {
    print_r($numero->getLastError());
}
/**
 * Sample call for NumeroContratEtudiant operation/method
 */
if ($numero->NumeroContratEtudiant($AEtudiant) !== false) {
    print_r($numero->getResult());
} else {
    print_r($numero->getLastError());
}
/**
 * Samples for Numeros ServiceType
 */
$numeros = new \hp_\Numeros($options);
/**
 * Sample call for NumerosINETableauDEtudiants operation/method
 */
if ($numeros->NumerosINETableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($numeros->getResult());
} else {
    print_r($numeros->getLastError());
}
/**
 * Sample call for NumerosDOrdreTableauDEtudiants operation/method
 */
if ($numeros->NumerosDOrdreTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($numeros->getResult());
} else {
    print_r($numeros->getLastError());
}
/**
 * Sample call for NumerosSecuriteSocialeTableauDEtudiants operation/method
 */
if ($numeros->NumerosSecuriteSocialeTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($numeros->getResult());
} else {
    print_r($numeros->getLastError());
}
/**
 * Sample call for NumerosContratTableauDEtudiants operation/method
 */
if ($numeros->NumerosContratTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($numeros->getResult());
} else {
    print_r($numeros->getLastError());
}
/**
 * Samples for Lieu ServiceType
 */
$lieu = new \hp_\Lieu($options);
/**
 * Sample call for LieuDeNaissanceEtudiant operation/method
 */
if ($lieu->LieuDeNaissanceEtudiant($AEtudiant) !== false) {
    print_r($lieu->getResult());
} else {
    print_r($lieu->getLastError());
}
/**
 * Samples for Lieux ServiceType
 */
$lieux = new \hp_\Lieux($options);
/**
 * Sample call for LieuxDeNaissanceTableauDEtudiants operation/method
 */
if ($lieux->LieuxDeNaissanceTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($lieux->getResult());
} else {
    print_r($lieux->getLastError());
}
/**
 * Samples for Nationalite ServiceType
 */
$nationalite = new \hp_\Nationalite($options);
/**
 * Sample call for NationaliteEtudiant operation/method
 */
if ($nationalite->NationaliteEtudiant($AEtudiant) !== false) {
    print_r($nationalite->getResult());
} else {
    print_r($nationalite->getLastError());
}
/**
 * Samples for Nationalites ServiceType
 */
$nationalites = new \hp_\Nationalites($options);
/**
 * Sample call for NationalitesTableauDEtudiants operation/method
 */
if ($nationalites->NationalitesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($nationalites->getResult());
} else {
    print_r($nationalites->getLastError());
}
/**
 * Samples for Mutuelle ServiceType
 */
$mutuelle = new \hp_\Mutuelle($options);
/**
 * Sample call for MutuelleEtudiant operation/method
 */
if ($mutuelle->MutuelleEtudiant($AEtudiant) !== false) {
    print_r($mutuelle->getResult());
} else {
    print_r($mutuelle->getLastError());
}
/**
 * Samples for Mutuelles ServiceType
 */
$mutuelles = new \hp_\Mutuelles($options);
/**
 * Sample call for MutuellesTableauDEtudiants operation/method
 */
if ($mutuelles->MutuellesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($mutuelles->getResult());
} else {
    print_r($mutuelles->getLastError());
}
/**
 * Samples for Cotisation ServiceType
 */
$cotisation = new \hp_\Cotisation($options);
/**
 * Sample call for CotisationEtudiant operation/method
 */
if ($cotisation->CotisationEtudiant($AEtudiant) !== false) {
    print_r($cotisation->getResult());
} else {
    print_r($cotisation->getLastError());
}
/**
 * Samples for Ne ServiceType
 */
$ne = new \hp_\Ne($options);
/**
 * Sample call for NePasRenseignerCotisationEtudiant operation/method
 */
if ($ne->NePasRenseignerCotisationEtudiant($AEtudiant) !== false) {
    print_r($ne->getResult());
} else {
    print_r($ne->getLastError());
}
/**
 * Sample call for NePasPublierLEtudiantSurLesEspaces operation/method
 */
if ($ne->NePasPublierLEtudiantSurLesEspaces($AEtudiant) !== false) {
    print_r($ne->getResult());
} else {
    print_r($ne->getLastError());
}
/**
 * Samples for Cotisations ServiceType
 */
$cotisations = new \hp_\Cotisations($options);
/**
 * Sample call for CotisationsTableauDEtudiants operation/method
 */
if ($cotisations->CotisationsTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($cotisations->getResult());
} else {
    print_r($cotisations->getLastError());
}
/**
 * Samples for Motif ServiceType
 */
$motif = new \hp_\Motif($options);
/**
 * Sample call for MotifNonCotisationEtudiant operation/method
 */
if ($motif->MotifNonCotisationEtudiant($AEtudiant) !== false) {
    print_r($motif->getResult());
} else {
    print_r($motif->getLastError());
}
/**
 * Samples for Motifs ServiceType
 */
$motifs = new \hp_\Motifs($options);
/**
 * Sample call for MotifsNonCotisationTableauDEtudiants operation/method
 */
if ($motifs->MotifsNonCotisationTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($motifs->getResult());
} else {
    print_r($motifs->getLastError());
}
/**
 * Samples for Assurance ServiceType
 */
$assurance = new \hp_\Assurance($options);
/**
 * Sample call for AssuranceResponsabiliteCivileEtudiant operation/method
 */
if ($assurance->AssuranceResponsabiliteCivileEtudiant($AEtudiant) !== false) {
    print_r($assurance->getResult());
} else {
    print_r($assurance->getLastError());
}
/**
 * Samples for Assurances ServiceType
 */
$assurances = new \hp_\Assurances($options);
/**
 * Sample call for AssurancesResponsabiliteCivileTableauDEtudiants operation/method
 */
if ($assurances->AssurancesResponsabiliteCivileTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($assurances->getResult());
} else {
    print_r($assurances->getLastError());
}
/**
 * Samples for Autre ServiceType
 */
$autre = new \hp_\Autre($options);
/**
 * Sample call for AutreInformationEtudiant operation/method
 */
if ($autre->AutreInformationEtudiant($AEtudiant) !== false) {
    print_r($autre->getResult());
} else {
    print_r($autre->getLastError());
}
/**
 * Samples for Autres ServiceType
 */
$autres = new \hp_\Autres($options);
/**
 * Sample call for AutresInformationsTableauDEtudiants operation/method
 */
if ($autres->AutresInformationsTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($autres->getResult());
} else {
    print_r($autres->getLastError());
}
/**
 * Samples for Commentaire ServiceType
 */
$commentaire = new \hp_\Commentaire($options);
/**
 * Sample call for CommentaireEtudiant operation/method
 */
if ($commentaire->CommentaireEtudiant($AEtudiant) !== false) {
    print_r($commentaire->getResult());
} else {
    print_r($commentaire->getLastError());
}
/**
 * Samples for Commentaires ServiceType
 */
$commentaires = new \hp_\Commentaires($options);
/**
 * Sample call for CommentairesTableauDEtudiants operation/method
 */
if ($commentaires->CommentairesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($commentaires->getResult());
} else {
    print_r($commentaires->getLastError());
}
/**
 * Samples for Code ServiceType
 */
$code = new \hp_\Code($options);
/**
 * Sample call for CodeFiscalEtudiant operation/method
 */
if ($code->CodeFiscalEtudiant($AEtudiant) !== false) {
    print_r($code->getResult());
} else {
    print_r($code->getLastError());
}
/**
 * Sample call for CodePostalEtudiant operation/method
 */
if ($code->CodePostalEtudiant($AEtudiant) !== false) {
    print_r($code->getResult());
} else {
    print_r($code->getLastError());
}
/**
 * Sample call for CodeBaccalaureatDeNom operation/method
 */
if ($code->CodeBaccalaureatDeNom($ANom) !== false) {
    print_r($code->getResult());
} else {
    print_r($code->getLastError());
}
/**
 * Sample call for CodeSpecialiteBacDeNom operation/method
 */
if ($code->CodeSpecialiteBacDeNom($ANom) !== false) {
    print_r($code->getResult());
} else {
    print_r($code->getLastError());
}
/**
 * Sample call for CodeDepartementDeNom operation/method
 */
if ($code->CodeDepartementDeNom($ANom) !== false) {
    print_r($code->getResult());
} else {
    print_r($code->getLastError());
}
/**
 * Sample call for CodeTypeDernierDiplomeDeNom operation/method
 */
if ($code->CodeTypeDernierDiplomeDeNom($ANom) !== false) {
    print_r($code->getResult());
} else {
    print_r($code->getLastError());
}
/**
 * Samples for Codes ServiceType
 */
$codes = new \hp_\Codes($options);
/**
 * Sample call for CodesFiscauxTableauDEtudiants operation/method
 */
if ($codes->CodesFiscauxTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($codes->getResult());
} else {
    print_r($codes->getLastError());
}
/**
 * Sample call for CodesPostauxTableauDEtudiants operation/method
 */
if ($codes->CodesPostauxTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($codes->getResult());
} else {
    print_r($codes->getLastError());
}
/**
 * Samples for Adresse ServiceType
 */
$adresse = new \hp_\Adresse($options);
/**
 * Sample call for Adresse1Etudiant operation/method
 */
if ($adresse->Adresse1Etudiant($AEtudiant) !== false) {
    print_r($adresse->getResult());
} else {
    print_r($adresse->getLastError());
}
/**
 * Sample call for Adresse2Etudiant operation/method
 */
if ($adresse->Adresse2Etudiant($AEtudiant) !== false) {
    print_r($adresse->getResult());
} else {
    print_r($adresse->getLastError());
}
/**
 * Sample call for Adresse3Etudiant operation/method
 */
if ($adresse->Adresse3Etudiant($AEtudiant) !== false) {
    print_r($adresse->getResult());
} else {
    print_r($adresse->getLastError());
}
/**
 * Sample call for Adresse4Etudiant operation/method
 */
if ($adresse->Adresse4Etudiant($AEtudiant) !== false) {
    print_r($adresse->getResult());
} else {
    print_r($adresse->getLastError());
}
/**
 * Samples for Adresses ServiceType
 */
$adresses = new \hp_\Adresses($options);
/**
 * Sample call for Adresses1TableauDEtudiants operation/method
 */
if ($adresses->Adresses1TableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($adresses->getResult());
} else {
    print_r($adresses->getLastError());
}
/**
 * Sample call for Adresses2TableauDEtudiants operation/method
 */
if ($adresses->Adresses2TableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($adresses->getResult());
} else {
    print_r($adresses->getLastError());
}
/**
 * Sample call for Adresses3TableauDEtudiants operation/method
 */
if ($adresses->Adresses3TableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($adresses->getResult());
} else {
    print_r($adresses->getLastError());
}
/**
 * Sample call for Adresses4TableauDEtudiants operation/method
 */
if ($adresses->Adresses4TableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($adresses->getResult());
} else {
    print_r($adresses->getLastError());
}
/**
 * Samples for Ville ServiceType
 */
$ville = new \hp_\Ville($options);
/**
 * Sample call for VilleEtudiant operation/method
 */
if ($ville->VilleEtudiant($AEtudiant) !== false) {
    print_r($ville->getResult());
} else {
    print_r($ville->getLastError());
}
/**
 * Samples for Villes ServiceType
 */
$villes = new \hp_\Villes($options);
/**
 * Sample call for VillesTableauDEtudiants operation/method
 */
if ($villes->VillesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($villes->getResult());
} else {
    print_r($villes->getLastError());
}
/**
 * Samples for Pays ServiceType
 */
$pays = new \hp_\Pays($options);
/**
 * Sample call for PaysEtudiant operation/method
 */
if ($pays->PaysEtudiant($AEtudiant) !== false) {
    print_r($pays->getResult());
} else {
    print_r($pays->getLastError());
}
/**
 * Sample call for PaysTableauDEtudiants operation/method
 */
if ($pays->PaysTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($pays->getResult());
} else {
    print_r($pays->getLastError());
}
/**
 * Samples for Province ServiceType
 */
$province = new \hp_\Province($options);
/**
 * Sample call for ProvinceEtudiant operation/method
 */
if ($province->ProvinceEtudiant($AEtudiant) !== false) {
    print_r($province->getResult());
} else {
    print_r($province->getLastError());
}
/**
 * Samples for Provinces ServiceType
 */
$provinces = new \hp_\Provinces($options);
/**
 * Sample call for ProvincesTableauDEtudiants operation/method
 */
if ($provinces->ProvincesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($provinces->getResult());
} else {
    print_r($provinces->getLastError());
}
/**
 * Samples for Telephone ServiceType
 */
$telephone = new \hp_\Telephone($options);
/**
 * Sample call for TelephoneFixeEtudiant operation/method
 */
if ($telephone->TelephoneFixeEtudiant($AEtudiant) !== false) {
    print_r($telephone->getResult());
} else {
    print_r($telephone->getLastError());
}
/**
 * Sample call for TelephonePortableEtudiant operation/method
 */
if ($telephone->TelephonePortableEtudiant($AEtudiant) !== false) {
    print_r($telephone->getResult());
} else {
    print_r($telephone->getLastError());
}
/**
 * Samples for Telephones ServiceType
 */
$telephones = new \hp_\Telephones($options);
/**
 * Sample call for TelephonesFixesTableauDEtudiants operation/method
 */
if ($telephones->TelephonesFixesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($telephones->getResult());
} else {
    print_r($telephones->getLastError());
}
/**
 * Sample call for TelephonesPortablesTableauDEtudiants operation/method
 */
if ($telephones->TelephonesPortablesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($telephones->getResult());
} else {
    print_r($telephones->getLastError());
}
/**
 * Samples for Indicatif ServiceType
 */
$indicatif = new \hp_\Indicatif($options);
/**
 * Sample call for IndicatifTelephoneFixeEtudiant operation/method
 */
if ($indicatif->IndicatifTelephoneFixeEtudiant($AEtudiant) !== false) {
    print_r($indicatif->getResult());
} else {
    print_r($indicatif->getLastError());
}
/**
 * Sample call for IndicatifTelephonePortableEtudiant operation/method
 */
if ($indicatif->IndicatifTelephonePortableEtudiant($AEtudiant) !== false) {
    print_r($indicatif->getResult());
} else {
    print_r($indicatif->getLastError());
}
/**
 * Samples for Indicatifs ServiceType
 */
$indicatifs = new \hp_\Indicatifs($options);
/**
 * Sample call for IndicatifsTelephonesFixesTableauDEtudiants operation/method
 */
if ($indicatifs->IndicatifsTelephonesFixesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($indicatifs->getResult());
} else {
    print_r($indicatifs->getLastError());
}
/**
 * Sample call for IndicatifsTelephonesPortablesTableauDEtudiants operation/method
 */
if ($indicatifs->IndicatifsTelephonesPortablesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($indicatifs->getResult());
} else {
    print_r($indicatifs->getLastError());
}
/**
 * Samples for Autorisation ServiceType
 */
$autorisation = new \hp_\Autorisation($options);
/**
 * Sample call for AutorisationReceptionSMSEtudiant operation/method
 */
if ($autorisation->AutorisationReceptionSMSEtudiant($AEtudiant) !== false) {
    print_r($autorisation->getResult());
} else {
    print_r($autorisation->getLastError());
}
/**
 * Sample call for AutorisationDiffusionPhotoEtudiant operation/method
 */
if ($autorisation->AutorisationDiffusionPhotoEtudiant($AEtudiant) !== false) {
    print_r($autorisation->getResult());
} else {
    print_r($autorisation->getLastError());
}
/**
 * Sample call for AutorisationDiffusionPhotoTableauDEtudiants operation/method
 */
if ($autorisation->AutorisationDiffusionPhotoTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($autorisation->getResult());
} else {
    print_r($autorisation->getLastError());
}
/**
 * Samples for Autorisations ServiceType
 */
$autorisations = new \hp_\Autorisations($options);
/**
 * Sample call for AutorisationsReceptionSMSTableauDEtudiants operation/method
 */
if ($autorisations->AutorisationsReceptionSMSTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($autorisations->getResult());
} else {
    print_r($autorisations->getLastError());
}
/**
 * Samples for LE ServiceType
 */
$lE = new \hp_\LE($options);
/**
 * Sample call for LEtudiantEstRedoublant operation/method
 */
if ($lE->LEtudiantEstRedoublant($AEtudiant) !== false) {
    print_r($lE->getResult());
} else {
    print_r($lE->getLastError());
}
/**
 * Samples for Le ServiceType
 */
$le = new \hp_\Le_1($options);
/**
 * Sample call for LeTableauDEtudiantsSontRedoublants operation/method
 */
if ($le->LeTableauDEtudiantsSontRedoublants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($le->getResult());
} else {
    print_r($le->getLastError());
}
/**
 * Samples for Baccalaureat ServiceType
 */
$baccalaureat = new \hp_\Baccalaureat($options);
/**
 * Sample call for BaccalaureatEtudiant operation/method
 */
if ($baccalaureat->BaccalaureatEtudiant($AEtudiant) !== false) {
    print_r($baccalaureat->getResult());
} else {
    print_r($baccalaureat->getLastError());
}
/**
 * Sample call for BaccalaureatTableauDEtudiants operation/method
 */
if ($baccalaureat->BaccalaureatTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($baccalaureat->getResult());
} else {
    print_r($baccalaureat->getLastError());
}
/**
 * Samples for Specialite ServiceType
 */
$specialite = new \hp_\Specialite($options);
/**
 * Sample call for Specialite1BacEtudiant operation/method
 */
if ($specialite->Specialite1BacEtudiant($AEtudiant) !== false) {
    print_r($specialite->getResult());
} else {
    print_r($specialite->getLastError());
}
/**
 * Sample call for Specialite1BacTableauDEtudiants operation/method
 */
if ($specialite->Specialite1BacTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($specialite->getResult());
} else {
    print_r($specialite->getLastError());
}
/**
 * Sample call for Specialite2BacEtudiant operation/method
 */
if ($specialite->Specialite2BacEtudiant($AEtudiant) !== false) {
    print_r($specialite->getResult());
} else {
    print_r($specialite->getLastError());
}
/**
 * Sample call for Specialite2BacTableauDEtudiants operation/method
 */
if ($specialite->Specialite2BacTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($specialite->getResult());
} else {
    print_r($specialite->getLastError());
}
/**
 * Samples for Departement ServiceType
 */
$departement = new \hp_\Departement($options);
/**
 * Sample call for DepartementObtentionBacEtudiant operation/method
 */
if ($departement->DepartementObtentionBacEtudiant($AEtudiant) !== false) {
    print_r($departement->getResult());
} else {
    print_r($departement->getLastError());
}
/**
 * Sample call for DepartementObtentionBacTableauDEtudiants operation/method
 */
if ($departement->DepartementObtentionBacTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($departement->getResult());
} else {
    print_r($departement->getLastError());
}
/**
 * Samples for Annee ServiceType
 */
$annee = new \hp_\Annee($options);
/**
 * Sample call for AnneeObtentionBacEtudiant operation/method
 */
if ($annee->AnneeObtentionBacEtudiant($AEtudiant) !== false) {
    print_r($annee->getResult());
} else {
    print_r($annee->getLastError());
}
/**
 * Sample call for AnneeObtentionBacTableauDEtudiants operation/method
 */
if ($annee->AnneeObtentionBacTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($annee->getResult());
} else {
    print_r($annee->getLastError());
}
/**
 * Samples for Niveau ServiceType
 */
$niveau = new \hp_\Niveau($options);
/**
 * Sample call for NiveauDansDiplomeEtudiant operation/method
 */
if ($niveau->NiveauDansDiplomeEtudiant($AEtudiant) !== false) {
    print_r($niveau->getResult());
} else {
    print_r($niveau->getLastError());
}
/**
 * Sample call for NiveauDansDiplomeTableauDEtudiants operation/method
 */
if ($niveau->NiveauDansDiplomeTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($niveau->getResult());
} else {
    print_r($niveau->getLastError());
}
/**
 * Samples for Type ServiceType
 */
$type = new \hp_\Type($options);
/**
 * Sample call for TypeDernierDiplomeEtudiant operation/method
 */
if ($type->TypeDernierDiplomeEtudiant($AEtudiant) !== false) {
    print_r($type->getResult());
} else {
    print_r($type->getLastError());
}
/**
 * Sample call for TypeDernierDiplomeTableauDEtudiants operation/method
 */
if ($type->TypeDernierDiplomeTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($type->getResult());
} else {
    print_r($type->getLastError());
}
/**
 * Samples for Modalite ServiceType
 */
$modalite = new \hp_\Modalite($options);
/**
 * Sample call for ModaliteDAdmissionEtudiant operation/method
 */
if ($modalite->ModaliteDAdmissionEtudiant($AEtudiant) !== false) {
    print_r($modalite->getResult());
} else {
    print_r($modalite->getLastError());
}
/**
 * Samples for Modalites ServiceType
 */
$modalites = new \hp_\Modalites($options);
/**
 * Sample call for ModalitesDAdmissionTableauDEtudiants operation/method
 */
if ($modalites->ModalitesDAdmissionTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($modalites->getResult());
} else {
    print_r($modalites->getLastError());
}
/**
 * Samples for Etablissement ServiceType
 */
$etablissement = new \hp_\Etablissement($options);
/**
 * Sample call for EtablissementOrigineEtudiant operation/method
 */
if ($etablissement->EtablissementOrigineEtudiant($AEtudiant) !== false) {
    print_r($etablissement->getResult());
} else {
    print_r($etablissement->getLastError());
}
/**
 * Samples for Etablissements ServiceType
 */
$etablissements = new \hp_\Etablissements($options);
/**
 * Sample call for EtablissementsOrigineTableauDEtudiants operation/method
 */
if ($etablissements->EtablissementsOrigineTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($etablissements->getResult());
} else {
    print_r($etablissements->getLastError());
}
/**
 * Samples for Email ServiceType
 */
$email = new \hp_\Email($options);
/**
 * Sample call for EmailEtablissementOrigine operation/method
 */
if ($email->EmailEtablissementOrigine($AEtablissement) !== false) {
    print_r($email->getResult());
} else {
    print_r($email->getLastError());
}
/**
 * Samples for Emails ServiceType
 */
$emails = new \hp_\Emails($options);
/**
 * Sample call for EmailsTableauDEtablissementsOrigine operation/method
 */
if ($emails->EmailsTableauDEtablissementsOrigine(new \hp_\THpSvcWTableauChaines()) !== false) {
    print_r($emails->getResult());
} else {
    print_r($emails->getLastError());
}
/**
 * Samples for Cursus ServiceType
 */
$cursus = new \hp_\Cursus($options);
/**
 * Sample call for CursusAnterieurEtudiant operation/method
 */
if ($cursus->CursusAnterieurEtudiant($AEtudiant) !== false) {
    print_r($cursus->getResult());
} else {
    print_r($cursus->getLastError());
}
/**
 * Sample call for CursusAnterieurTableauDEtudiants operation/method
 */
if ($cursus->CursusAnterieurTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($cursus->getResult());
} else {
    print_r($cursus->getLastError());
}
/**
 * Samples for Proprietaire ServiceType
 */
$proprietaire = new \hp_\Proprietaire($options);
/**
 * Sample call for ProprietaireEtudiant operation/method
 */
if ($proprietaire->ProprietaireEtudiant($AEtudiant) !== false) {
    print_r($proprietaire->getResult());
} else {
    print_r($proprietaire->getLastError());
}
/**
 * Samples for Proprietaires ServiceType
 */
$proprietaires = new \hp_\Proprietaires($options);
/**
 * Sample call for ProprietairesTableauDEtudiants operation/method
 */
if ($proprietaires->ProprietairesTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($proprietaires->getResult());
} else {
    print_r($proprietaires->getLastError());
}
/**
 * Samples for Publier ServiceType
 */
$publier = new \hp_\Publier($options);
/**
 * Sample call for PublierLEtudiantSurTousLesEspaces operation/method
 */
if ($publier->PublierLEtudiantSurTousLesEspaces($AEtudiant) !== false) {
    print_r($publier->getResult());
} else {
    print_r($publier->getLastError());
}
/**
 * Samples for Etudiant ServiceType
 */
$etudiant = new \hp_\Etudiant($options);
/**
 * Sample call for EtudiantPublieSurTousLesEspaces operation/method
 */
if ($etudiant->EtudiantPublieSurTousLesEspaces($AEtudiant) !== false) {
    print_r($etudiant->getResult());
} else {
    print_r($etudiant->getLastError());
}
/**
 * Samples for Etudiants ServiceType
 */
$etudiants = new \hp_\Etudiants($options);
/**
 * Sample call for EtudiantsPubliesSurTousLesEspaces operation/method
 */
if ($etudiants->EtudiantsPubliesSurTousLesEspaces(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($etudiants->getResult());
} else {
    print_r($etudiants->getLastError());
}
/**
 * Sample call for EtudiantsPromotion operation/method
 */
if ($etudiants->EtudiantsPromotion($APromotion) !== false) {
    print_r($etudiants->getResult());
} else {
    print_r($etudiants->getLastError());
}
/**
 * Sample call for EtudiantsPromotionALaDate operation/method
 */
if ($etudiants->EtudiantsPromotionALaDate($APromotion, $ADate) !== false) {
    print_r($etudiants->getResult());
} else {
    print_r($etudiants->getLastError());
}
/**
 * Sample call for EtudiantsPromotionEntre2Dates operation/method
 */
if ($etudiants->EtudiantsPromotionEntre2Dates($APromotion, $ADateDebut, $ADateFin) !== false) {
    print_r($etudiants->getResult());
} else {
    print_r($etudiants->getLastError());
}
/**
 * Sample call for EtudiantsTDOption operation/method
 */
if ($etudiants->EtudiantsTDOption($ATDOption) !== false) {
    print_r($etudiants->getResult());
} else {
    print_r($etudiants->getLastError());
}
/**
 * Sample call for EtudiantsTDOptionALaDate operation/method
 */
if ($etudiants->EtudiantsTDOptionALaDate($ATDOption, $ADate) !== false) {
    print_r($etudiants->getResult());
} else {
    print_r($etudiants->getLastError());
}
/**
 * Sample call for EtudiantsTDOptionEntre2Dates operation/method
 */
if ($etudiants->EtudiantsTDOptionEntre2Dates($ATDOption, $ADateDebut, $ADateFin) !== false) {
    print_r($etudiants->getResult());
} else {
    print_r($etudiants->getLastError());
}
/**
 * Sample call for EtudiantsCours operation/method
 */
if ($etudiants->EtudiantsCours($ACours) !== false) {
    print_r($etudiants->getResult());
} else {
    print_r($etudiants->getLastError());
}
/**
 * Samples for Photo ServiceType
 */
$photo = new \hp_\Photo($options);
/**
 * Sample call for PhotoEtudiant operation/method
 */
if ($photo->PhotoEtudiant($AEtudiant, $AFormat) !== false) {
    print_r($photo->getResult());
} else {
    print_r($photo->getLastError());
}
/**
 * Samples for Effacer ServiceType
 */
$effacer = new \hp_\Effacer($options);
/**
 * Sample call for EffacerPhotoEtudiant operation/method
 */
if ($effacer->EffacerPhotoEtudiant($AEtudiant) !== false) {
    print_r($effacer->getResult());
} else {
    print_r($effacer->getLastError());
}
/**
 * Samples for Regroupements ServiceType
 */
$regroupements = new \hp_\Regroupements($options);
/**
 * Sample call for RegroupementsEtudiant operation/method
 */
if ($regroupements->RegroupementsEtudiant($AEtudiant) !== false) {
    print_r($regroupements->getResult());
} else {
    print_r($regroupements->getLastError());
}
/**
 * Sample call for RegroupementsEtudiantALaDate operation/method
 */
if ($regroupements->RegroupementsEtudiantALaDate($AEtudiant, $ADate) !== false) {
    print_r($regroupements->getResult());
} else {
    print_r($regroupements->getLastError());
}
/**
 * Sample call for RegroupementsEtudiantEntre2Dates operation/method
 */
if ($regroupements->RegroupementsEtudiantEntre2Dates($AEtudiant, $ADateDebut, $ADateFin) !== false) {
    print_r($regroupements->getResult());
} else {
    print_r($regroupements->getLastError());
}
/**
 * Samples for Promotion ServiceType
 */
$promotion = new \hp_\Promotion($options);
/**
 * Sample call for PromotionEtudiant operation/method
 */
if ($promotion->PromotionEtudiant($AEtudiant) !== false) {
    print_r($promotion->getResult());
} else {
    print_r($promotion->getLastError());
}
/**
 * Samples for Promotions ServiceType
 */
$promotions = new \hp_\Promotions($options);
/**
 * Sample call for PromotionsEtudiant operation/method
 */
if ($promotions->PromotionsEtudiant($AEtudiant) !== false) {
    print_r($promotions->getResult());
} else {
    print_r($promotions->getLastError());
}
/**
 * Sample call for PromotionsEtudiantALaDate operation/method
 */
if ($promotions->PromotionsEtudiantALaDate($AEtudiant, $ADate) !== false) {
    print_r($promotions->getResult());
} else {
    print_r($promotions->getLastError());
}
/**
 * Sample call for PromotionsEtudiantEntre2Dates operation/method
 */
if ($promotions->PromotionsEtudiantEntre2Dates($AEtudiant, $ADateDebut, $ADateFin) !== false) {
    print_r($promotions->getResult());
} else {
    print_r($promotions->getLastError());
}
/**
 * Samples for Ajouter ServiceType
 */
$ajouter = new \hp_\Ajouter($options);
/**
 * Sample call for AjouterEtudiantALaPromotion operation/method
 */
if ($ajouter->AjouterEtudiantALaPromotion($AEtudiant, $APromotion) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterEtudiantALaPromotionALaDate operation/method
 */
if ($ajouter->AjouterEtudiantALaPromotionALaDate($AEtudiant, $APromotion, $ADate) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterEtudiantATDOption operation/method
 */
if ($ajouter->AjouterEtudiantATDOption($AEtudiant, $ATDOption) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterEtudiantATDOptionALaDate operation/method
 */
if ($ajouter->AjouterEtudiantATDOptionALaDate($AEtudiant, $ATDOption, $ADate) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Samples for Enlever ServiceType
 */
$enlever = new \hp_\Enlever($options);
/**
 * Sample call for EnleverEtudiantDeLaPromotion operation/method
 */
if ($enlever->EnleverEtudiantDeLaPromotion($AEtudiant, $APromotion) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverEtudiantDeLaPromotionALaDate operation/method
 */
if ($enlever->EnleverEtudiantDeLaPromotionALaDate($AEtudiant, $APromotion, $ADate) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverEtudiantDeTDOption operation/method
 */
if ($enlever->EnleverEtudiantDeTDOption($AEtudiant, $ATDOption) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverEtudiantDeTDOptionALaDate operation/method
 */
if ($enlever->EnleverEtudiantDeTDOptionALaDate($AEtudiant, $ATDOption, $ADate) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Samples for TDO ServiceType
 */
$tDO = new \hp_\TDO($options);
/**
 * Sample call for TDOptionsEtudiant operation/method
 */
if ($tDO->TDOptionsEtudiant($AEtudiant) !== false) {
    print_r($tDO->getResult());
} else {
    print_r($tDO->getLastError());
}
/**
 * Sample call for TDOptionsEtudiantALaDate operation/method
 */
if ($tDO->TDOptionsEtudiantALaDate($AEtudiant, $ADate) !== false) {
    print_r($tDO->getResult());
} else {
    print_r($tDO->getLastError());
}
/**
 * Sample call for TDOptionsEtudiantEntre2Dates operation/method
 */
if ($tDO->TDOptionsEtudiantEntre2Dates($AEtudiant, $ADateDebut, $ADateFin) !== false) {
    print_r($tDO->getResult());
} else {
    print_r($tDO->getLastError());
}
/**
 * Samples for Cours ServiceType
 */
$cours = new \hp_\Cours($options);
/**
 * Sample call for CoursEtudiant operation/method
 */
if ($cours->CoursEtudiant($AEtudiant) !== false) {
    print_r($cours->getResult());
} else {
    print_r($cours->getLastError());
}
/**
 * Sample call for CoursEtudiantEntre2Dates operation/method
 */
if ($cours->CoursEtudiantEntre2Dates($AEtudiant, $ADate1, $ADate2) !== false) {
    print_r($cours->getResult());
} else {
    print_r($cours->getLastError());
}
/**
 * Samples for Ical ServiceType
 */
$ical = new \hp_\Ical($options);
/**
 * Sample call for IcalEmploiDuTempsEtudiant operation/method
 */
if ($ical->IcalEmploiDuTempsEtudiant($AEtudiant, new \hp_\THpSvcWTableauSemaines(), $AAvecFuseauHoraire, $AAvecDateSeances, $AAvecType, $AAvecPonderation, $AAvecMemo, $AAvecEffectif, $AAvecSites, $AFormatTexteMatiere, $AFormatTexteEnseignants, $AFormatTexteRegroupements, $AFormatTextePromotions, $AFormatTexteTD, $AFormatTexteOptions, $AFormatTexteSalles) !== false) {
    print_r($ical->getResult());
} else {
    print_r($ical->getLastError());
}
/**
 * Sample call for IcalEmploiDuTempsTableauDEtudiants operation/method
 */
if ($ical->IcalEmploiDuTempsTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants(), new \hp_\THpSvcWTableauSemaines(), $AAvecFuseauHoraire, $AAvecDateSeances, $AAvecType, $AAvecPonderation, $AAvecMemo, $AAvecEffectif, $AAvecSites, $AFormatTexteMatiere, $AFormatTexteEnseignants, $AFormatTexteRegroupements, $AFormatTextePromotions, $AFormatTexteTD, $AFormatTexteOptions, $AFormatTexteSalles) !== false) {
    print_r($ical->getResult());
} else {
    print_r($ical->getLastError());
}
/**
 * Sample call for IcalEtudiant operation/method
 */
if ($ical->IcalEtudiant($AEtudiant, new \hp_\THpSvcWTableauSemaines(), new \hp_\THpSvcWTableauFormatICAL(), $AFormatTexteMatiere, $AFormatTexteEnseignants, $AFormatTexteRegroupements, $AFormatTextePromotions, $AFormatTexteTD, $AFormatTexteOptions, $AFormatTexteSalles) !== false) {
    print_r($ical->getResult());
} else {
    print_r($ical->getLastError());
}
/**
 * Sample call for IcalTableauDEtudiants operation/method
 */
if ($ical->IcalTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants(), new \hp_\THpSvcWTableauSemaines(), new \hp_\THpSvcWTableauFormatICAL(), $AFormatTexteMatiere, $AFormatTexteEnseignants, $AFormatTexteRegroupements, $AFormatTextePromotions, $AFormatTexteTD, $AFormatTexteOptions, $AFormatTexteSalles) !== false) {
    print_r($ical->getResult());
} else {
    print_r($ical->getLastError());
}
/**
 * Samples for URLI ServiceType
 */
$uRLI = new \hp_\URLI($options);
/**
 * Sample call for URLIcalEtudiant operation/method
 */
if ($uRLI->URLIcalEtudiant($AEtudiant) !== false) {
    print_r($uRLI->getResult());
} else {
    print_r($uRLI->getLastError());
}
/**
 * Sample call for URLIcalTableauDEtudiants operation/method
 */
if ($uRLI->URLIcalTableauDEtudiants(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($uRLI->getResult());
} else {
    print_r($uRLI->getLastError());
}
/**
 * Samples for Parent ServiceType
 */
$parent = new \hp_\_Parent($options);
/**
 * Sample call for Parent1Etudiant operation/method
 */
if ($parent->Parent1Etudiant($AEtudiant) !== false) {
    print_r($parent->getResult());
} else {
    print_r($parent->getLastError());
}
/**
 * Sample call for Parent2Etudiant operation/method
 */
if ($parent->Parent2Etudiant($AEtudiant) !== false) {
    print_r($parent->getResult());
} else {
    print_r($parent->getLastError());
}
/**
 * Samples for Trier ServiceType
 */
$trier = new \hp_\Trier($options);
/**
 * Sample call for TrierTableauDEtudiantsParCle operation/method
 */
if ($trier->TrierTableauDEtudiantsParCle(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($trier->getResult());
} else {
    print_r($trier->getLastError());
}
/**
 * Sample call for TrierTableauDEtudiantsParNomPrenomEtDateDeNaissance
 * operation/method
 */
if ($trier->TrierTableauDEtudiantsParNomPrenomEtDateDeNaissance(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($trier->getResult());
} else {
    print_r($trier->getLastError());
}
/**
 * Sample call for TrierTableauDEtudiantsParIdentifiant operation/method
 */
if ($trier->TrierTableauDEtudiantsParIdentifiant(new \hp_\THpSvcWTableauClesEtudiants()) !== false) {
    print_r($trier->getResult());
} else {
    print_r($trier->getLastError());
}
