<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Supprimer ServiceType
 * @subpackage Services
 */
class Supprimer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SupprimerEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Supprime l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return void|bool
     */
    public function SupprimerEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->SupprimerEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SupprimerTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Supprime les étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return void|bool
     */
    public function SupprimerTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->SupprimerTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SupprimerEtablissementOrigine
     * Meta information extracted from the WSDL
     * - documentation: Supprime l'établissement d'origine seulement s'il n'est pas utilisé
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNomEtablissement
     * @return void|bool
     */
    public function SupprimerEtablissementOrigine($aNomEtablissement)
    {
        try {
            $this->setResult($this->getSoapClient()->SupprimerEtablissementOrigine($aNomEtablissement));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SupprimerTableauDEtablissementsOrigine
     * Meta information extracted from the WSDL
     * - documentation: Supprime les établissements d'origine seulement s'ils ne sont pas utilisés
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauChaines $aTableau
     * @return void|bool
     */
    public function SupprimerTableauDEtablissementsOrigine(\hp_\THpSvcWTableauChaines $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->SupprimerTableauDEtablissementsOrigine($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
