<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Publier ServiceType
 * @subpackage Services
 */
class Publier extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PublierLEtudiantSurTousLesEspaces
     * Meta information extracted from the WSDL
     * - documentation: Permet de publier l'étudiant de clé 'AEtudiant' sur tous les espaces du .Net
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return void|bool
     */
    public function PublierLEtudiantSurTousLesEspaces($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->PublierLEtudiantSurTousLesEspaces($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
