<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Proprietaires ServiceType
 * @subpackage Services
 */
class Proprietaires extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProprietairesTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Nom et prénom des propriétaires des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauChaines|bool
     */
    public function ProprietairesTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->ProprietairesTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
