<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modifier ServiceType
 * @subpackage Services
 */
class Modifier extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ModifierNomEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le nom de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aNom
     * @return void|bool
     */
    public function ModifierNomEtudiant($aEtudiant, $aNom)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierNomEtudiant($aEtudiant, $aNom));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierPrenomEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le prénom 1 de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPrenom
     * @return void|bool
     */
    public function ModifierPrenomEtudiant($aEtudiant, $aPrenom)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierPrenomEtudiant($aEtudiant, $aPrenom));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierPrenom2Etudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le prénom 2 de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPrenom2
     * @return void|bool
     */
    public function ModifierPrenom2Etudiant($aEtudiant, $aPrenom2)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierPrenom2Etudiant($aEtudiant, $aPrenom2));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierPrenom3Etudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le prénom 3 de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPrenom3
     * @return void|bool
     */
    public function ModifierPrenom3Etudiant($aEtudiant, $aPrenom3)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierPrenom3Etudiant($aEtudiant, $aPrenom3));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierPrenomUsageEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le prénom d'usage de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPrenomUsage
     * @return void|bool
     */
    public function ModifierPrenomUsageEtudiant($aEtudiant, $aPrenomUsage)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierPrenomUsageEtudiant($aEtudiant, $aPrenomUsage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierDateDeNaissanceEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la date de naissance de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aDateDeNaissance
     * @return void|bool
     */
    public function ModifierDateDeNaissanceEtudiant($aEtudiant, $aDateDeNaissance)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierDateDeNaissanceEtudiant($aEtudiant, $aDateDeNaissance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierCiviliteEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la civilité de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCivilite
     * @return void|bool
     */
    public function ModifierCiviliteEtudiant($aEtudiant, $aCivilite)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierCiviliteEtudiant($aEtudiant, $aCivilite));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierIdentifiantEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le UID-Identifiant de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aIdentifiant
     * @return void|bool
     */
    public function ModifierIdentifiantEtudiant($aEtudiant, $aIdentifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierIdentifiantEtudiant($aEtudiant, $aIdentifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierIdentifiantCASEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'identifiant CAS de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aIdentifiant
     * @return void|bool
     */
    public function ModifierIdentifiantCASEtudiant($aEtudiant, $aIdentifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierIdentifiantCASEtudiant($aEtudiant, $aIdentifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierIdentifiantConnexionEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'identifiant de connexion de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aIdentifiant
     * @return void|bool
     */
    public function ModifierIdentifiantConnexionEtudiant($aEtudiant, $aIdentifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierIdentifiantConnexionEtudiant($aEtudiant, $aIdentifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierMotDePasseEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le mot de passe de l'étudiant de clé 'AEtudiant'. Renvoie une exception si l'UID-identifiant de l'étudiant est vide. Opération autorisée seulement pour un administrateur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aMotDePasse
     * @return void|bool
     */
    public function ModifierMotDePasseEtudiant($aEtudiant, $aMotDePasse)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierMotDePasseEtudiant($aEtudiant, $aMotDePasse));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierEMailEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'email de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aEMail
     * @return void|bool
     */
    public function ModifierEMailEtudiant($aEtudiant, $aEMail)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierEMailEtudiant($aEtudiant, $aEMail));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierEstDestinataireCourriersAbsencesEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Permet ou non à l'étudiant d'être destinataire des courriers liés à la vie scolaire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aEstDestinataire
     * @return void|bool
     */
    public function ModifierEstDestinataireCourriersAbsencesEtudiant($aEtudiant, $aEstDestinataire)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierEstDestinataireCourriersAbsencesEtudiant($aEtudiant, $aEstDestinataire));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierSexeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le sexe de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aSexe
     * @return void|bool
     */
    public function ModifierSexeEtudiant($aEtudiant, $aSexe)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierSexeEtudiant($aEtudiant, $aSexe));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierNumeroINEEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le numéro INE de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aNumeroINE
     * @return void|bool
     */
    public function ModifierNumeroINEEtudiant($aEtudiant, $aNumeroINE)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierNumeroINEEtudiant($aEtudiant, $aNumeroINE));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierNumeroDOrdreEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le numéro d'ordre de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aNumeroDOrdre
     * @return void|bool
     */
    public function ModifierNumeroDOrdreEtudiant($aEtudiant, $aNumeroDOrdre)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierNumeroDOrdreEtudiant($aEtudiant, $aNumeroDOrdre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierNomJeuneFilleEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le nom de jeune fille de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aNomJeuneFille
     * @return void|bool
     */
    public function ModifierNomJeuneFilleEtudiant($aEtudiant, $aNomJeuneFille)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierNomJeuneFilleEtudiant($aEtudiant, $aNomJeuneFille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierLieuDeNaissanceEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le lieu de naissance de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aVille
     * @return void|bool
     */
    public function ModifierLieuDeNaissanceEtudiant($aEtudiant, $aVille)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierLieuDeNaissanceEtudiant($aEtudiant, $aVille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierNationaliteEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la nationalité de l'étudiant de clé 'AEtudiant' - Si plusieurs nationalités, les séparer par des virgules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aNationalite
     * @return void|bool
     */
    public function ModifierNationaliteEtudiant($aEtudiant, $aNationalite)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierNationaliteEtudiant($aEtudiant, $aNationalite));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierNumeroSecuriteSocialeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le numéro de sécurité sociale de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aNumeroSS
     * @return void|bool
     */
    public function ModifierNumeroSecuriteSocialeEtudiant($aEtudiant, $aNumeroSS)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierNumeroSecuriteSocialeEtudiant($aEtudiant, $aNumeroSS));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierCleSecuriteSocialeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la clé de sécurité sociale de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCleSS
     * @return void|bool
     */
    public function ModifierCleSecuriteSocialeEtudiant($aEtudiant, $aCleSS)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierCleSecuriteSocialeEtudiant($aEtudiant, $aCleSS));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierMutuelleEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la mutuelle de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aMutuelle
     * @return void|bool
     */
    public function ModifierMutuelleEtudiant($aEtudiant, $aMutuelle)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierMutuelleEtudiant($aEtudiant, $aMutuelle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierCotisationEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la cotisation à une mutuelle de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCotisation
     * @return void|bool
     */
    public function ModifierCotisationEtudiant($aEtudiant, $aCotisation)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierCotisationEtudiant($aEtudiant, $aCotisation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierMotifNonCotisationEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le motif de non cotisation à une mutuelle de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aMotif
     * @return void|bool
     */
    public function ModifierMotifNonCotisationEtudiant($aEtudiant, $aMotif)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierMotifNonCotisationEtudiant($aEtudiant, $aMotif));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierAssuranceResponsabiliteCivileEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'assurance responsabilité civile de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aAssurance
     * @return void|bool
     */
    public function ModifierAssuranceResponsabiliteCivileEtudiant($aEtudiant, $aAssurance)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierAssuranceResponsabiliteCivileEtudiant($aEtudiant, $aAssurance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierNumeroContratEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le numéro de contrat de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aNumeroContrat
     * @return void|bool
     */
    public function ModifierNumeroContratEtudiant($aEtudiant, $aNumeroContrat)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierNumeroContratEtudiant($aEtudiant, $aNumeroContrat));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierAutreInformationEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'autre information de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aAutreInformation
     * @return void|bool
     */
    public function ModifierAutreInformationEtudiant($aEtudiant, $aAutreInformation)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierAutreInformationEtudiant($aEtudiant, $aAutreInformation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierCommentaireEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le commentaire de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCommentaire
     * @return void|bool
     */
    public function ModifierCommentaireEtudiant($aEtudiant, $aCommentaire)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierCommentaireEtudiant($aEtudiant, $aCommentaire));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierCodeFiscalEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le code fiscal de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCodeFiscal
     * @return void|bool
     */
    public function ModifierCodeFiscalEtudiant($aEtudiant, $aCodeFiscal)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierCodeFiscalEtudiant($aEtudiant, $aCodeFiscal));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierAdresse1Etudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'adresse1 de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aAdresse1
     * @return void|bool
     */
    public function ModifierAdresse1Etudiant($aEtudiant, $aAdresse1)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierAdresse1Etudiant($aEtudiant, $aAdresse1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierAdresse2Etudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'adresse2 de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aAdresse2
     * @return void|bool
     */
    public function ModifierAdresse2Etudiant($aEtudiant, $aAdresse2)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierAdresse2Etudiant($aEtudiant, $aAdresse2));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierAdresse3Etudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'adresse3 de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aAdresse3
     * @return void|bool
     */
    public function ModifierAdresse3Etudiant($aEtudiant, $aAdresse3)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierAdresse3Etudiant($aEtudiant, $aAdresse3));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierAdresse4Etudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'adresse4 de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aAdresse4
     * @return void|bool
     */
    public function ModifierAdresse4Etudiant($aEtudiant, $aAdresse4)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierAdresse4Etudiant($aEtudiant, $aAdresse4));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierCodePostalEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le code postal de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCodePostal
     * @return void|bool
     */
    public function ModifierCodePostalEtudiant($aEtudiant, $aCodePostal)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierCodePostalEtudiant($aEtudiant, $aCodePostal));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierVilleEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la ville de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aVille
     * @return void|bool
     */
    public function ModifierVilleEtudiant($aEtudiant, $aVille)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierVilleEtudiant($aEtudiant, $aVille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierPaysEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le pays de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPays
     * @return void|bool
     */
    public function ModifierPaysEtudiant($aEtudiant, $aPays)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierPaysEtudiant($aEtudiant, $aPays));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierProvinceEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la province de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aProvince
     * @return void|bool
     */
    public function ModifierProvinceEtudiant($aEtudiant, $aProvince)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierProvinceEtudiant($aEtudiant, $aProvince));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierTelephoneFixeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le téléphone fixe de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aTelephoneFixe
     * @return void|bool
     */
    public function ModifierTelephoneFixeEtudiant($aEtudiant, $aTelephoneFixe)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierTelephoneFixeEtudiant($aEtudiant, $aTelephoneFixe));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierIndicatifTelephoneFixeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'indicatif du téléphone fixe de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aIndicatif
     * @return void|bool
     */
    public function ModifierIndicatifTelephoneFixeEtudiant($aEtudiant, $aIndicatif)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierIndicatifTelephoneFixeEtudiant($aEtudiant, $aIndicatif));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierTelephonePortableEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le téléphone portable de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aTelephonePortable
     * @return void|bool
     */
    public function ModifierTelephonePortableEtudiant($aEtudiant, $aTelephonePortable)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierTelephonePortableEtudiant($aEtudiant, $aTelephonePortable));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierIndicatifTelephonePortableEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'indicatif du téléphone portable de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aIndicatif
     * @return void|bool
     */
    public function ModifierIndicatifTelephonePortableEtudiant($aEtudiant, $aIndicatif)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierIndicatifTelephonePortableEtudiant($aEtudiant, $aIndicatif));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierAutorisationReceptionSMSEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Permet d'autoriser ou d'interdire la réception de SMS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aAutorisationSMS
     * @return void|bool
     */
    public function ModifierAutorisationReceptionSMSEtudiant($aEtudiant, $aAutorisationSMS)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierAutorisationReceptionSMSEtudiant($aEtudiant, $aAutorisationSMS));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierRedoublantEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie si l'étudiant de clé 'AEtudiant' est redoublant ou non
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aRedoublant
     * @return void|bool
     */
    public function ModifierRedoublantEtudiant($aEtudiant, $aRedoublant)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierRedoublantEtudiant($aEtudiant, $aRedoublant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierBaccalaureatEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le baccalauréat de l'étudiant de clé 'AEtudiant'. Renvoie une exception si le code n'existe pas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCodeBaccalaureat
     * @return void|bool
     */
    public function ModifierBaccalaureatEtudiant($aEtudiant, $aCodeBaccalaureat)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierBaccalaureatEtudiant($aEtudiant, $aCodeBaccalaureat));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierSpecialite1BacEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la spécialité 1 de l'étudiant de clé 'AEtudiant'. Renvoie une exception si le code n'existe pas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCodeSpecialite1
     * @return void|bool
     */
    public function ModifierSpecialite1BacEtudiant($aEtudiant, $aCodeSpecialite1)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierSpecialite1BacEtudiant($aEtudiant, $aCodeSpecialite1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierSpecialite2BacEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la spécialité 2 de l'étudiant de clé 'AEtudiant'. Renvoie une exception si le code n'existe pas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCodeSpecialite2
     * @return void|bool
     */
    public function ModifierSpecialite2BacEtudiant($aEtudiant, $aCodeSpecialite2)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierSpecialite2BacEtudiant($aEtudiant, $aCodeSpecialite2));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierDepartementObtentionBacEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le département d'obtention de l'étudiant de clé 'AEtudiant'. Renvoie une exception si le code n'existe pas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCodeDepartementObt
     * @return void|bool
     */
    public function ModifierDepartementObtentionBacEtudiant($aEtudiant, $aCodeDepartementObt)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierDepartementObtentionBacEtudiant($aEtudiant, $aCodeDepartementObt));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierAnneeObtentionBacEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'année d'obtention de l'étudiant de clé 'AEtudiant'. Renvoie une exception si le format est invalide (YYYY entre 1900 et 2100)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aAnneeObt
     * @return void|bool
     */
    public function ModifierAnneeObtentionBacEtudiant($aEtudiant, $aAnneeObt)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierAnneeObtentionBacEtudiant($aEtudiant, $aAnneeObt));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierNiveauDansDiplomeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le niveau dans le diplôme atteint par l'étudiant de clé 'AEtudiant' le 15 janvier de l'année en cours. Renvoie une exception si le format est invalide (entre 01 et 10)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aNiveau
     * @return void|bool
     */
    public function ModifierNiveauDansDiplomeEtudiant($aEtudiant, $aNiveau)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierNiveauDansDiplomeEtudiant($aEtudiant, $aNiveau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierTypeDernierDiplomeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le type du dernier diplôme obtenu par l'étudiant de clé 'AEtudiant'. Renvoie une exception si le code n'existe pas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCodeTypeDernierDiplome
     * @return void|bool
     */
    public function ModifierTypeDernierDiplomeEtudiant($aEtudiant, $aCodeTypeDernierDiplome)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierTypeDernierDiplomeEtudiant($aEtudiant, $aCodeTypeDernierDiplome));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierModaliteDAdmissionEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la modalité d'admission de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aModalite
     * @return void|bool
     */
    public function ModifierModaliteDAdmissionEtudiant($aEtudiant, $aModalite)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierModaliteDAdmissionEtudiant($aEtudiant, $aModalite));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierEtablissementOrigineEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'établissement d'origine de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aNomEtablissement
     * @return void|bool
     */
    public function ModifierEtablissementOrigineEtudiant($aEtudiant, $aNomEtablissement)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierEtablissementOrigineEtudiant($aEtudiant, $aNomEtablissement));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierEmailEtablissementOrigine
     * Meta information extracted from the WSDL
     * - documentation: Modifie l'e-mail de l'établissement d'origine de nom 'ANomEtablissement'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNomEtablissement
     * @param string $aEmailEtablissement
     * @return void|bool
     */
    public function ModifierEmailEtablissementOrigine($aNomEtablissement, $aEmailEtablissement)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierEmailEtablissementOrigine($aNomEtablissement, $aEmailEtablissement));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierDateInscriptionEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la date d'inscription de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aDateInscription
     * @return void|bool
     */
    public function ModifierDateInscriptionEtudiant($aEtudiant, $aDateInscription)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierDateInscriptionEtudiant($aEtudiant, $aDateInscription));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierCursusAnterieurEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le cursus antérieur de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aCursusAnterieur
     * @return void|bool
     */
    public function ModifierCursusAnterieurEtudiant($aEtudiant, $aCursusAnterieur)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierCursusAnterieurEtudiant($aEtudiant, $aCursusAnterieur));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierProprietaireEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie le propriétaire de l'étudiant de clé 'AEtudiant'. Opération autorisée seulement pour un administrateur.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aNomProprietaire
     * @param string $aPrenomProprietaire
     * @return void|bool
     */
    public function ModifierProprietaireEtudiant($aEtudiant, $aNomProprietaire, $aPrenomProprietaire)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierProprietaireEtudiant($aEtudiant, $aNomProprietaire, $aPrenomProprietaire));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierPhotoEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la photo de l'étudiant de clé 'AEtudiant' avec un flux photo 'APhoto' au format 'AFormat'.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aFormat
     * @param string $aPhoto
     * @return void|bool
     */
    public function ModifierPhotoEtudiant($aEtudiant, $aFormat, $aPhoto)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierPhotoEtudiant($aEtudiant, $aFormat, $aPhoto));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ModifierAutorisationDiffusionPhotoEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Permet à l'étudiant de clé 'AEtudiant' d'autoriser ou non la diffusion de sa photo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aAutorise
     * @return void|bool
     */
    public function ModifierAutorisationDiffusionPhotoEtudiant($aEtudiant, $aAutorise)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierAutorisationDiffusionPhotoEtudiant($aEtudiant, $aAutorise));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ModifierPromotionEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modifie la promotion de l'étudiant de clé 'AEtudiant' sur l'année. Échoue si l'étudiant spécifié est dans plusieurs promotions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPromotion
     * @return void|bool
     */
    public function ModifierPromotionEtudiant($aEtudiant, $aPromotion)
    {
        try {
            $this->setResult($this->getSoapClient()->ModifierPromotionEtudiant($aEtudiant, $aPromotion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
