<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Indicatif ServiceType
 * @subpackage Services
 */
class Indicatif extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IndicatifTelephoneFixeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Indicatif du téléphone fixe de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function IndicatifTelephoneFixeEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->IndicatifTelephoneFixeEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IndicatifTelephonePortableEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Indicatif du téléphone portable de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function IndicatifTelephonePortableEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->IndicatifTelephonePortableEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
