<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Identifiant ServiceType
 * @subpackage Services
 */
class Identifiant extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IdentifiantEtudiant
     * Meta information extracted from the WSDL
     * - documentation: UID-Identifiant de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function IdentifiantEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->IdentifiantEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IdentifiantCASEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Identifiant CAS de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function IdentifiantCASEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->IdentifiantCASEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IdentifiantConnexionEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Identifiant de connexion de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function IdentifiantConnexionEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->IdentifiantConnexionEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
