<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Etudiant ServiceType
 * @subpackage Services
 */
class Etudiant extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EtudiantPublieSurTousLesEspaces
     * Meta information extracted from the WSDL
     * - documentation: Vrai si l'étudiant de clé 'AEtudiant' est publié sur tous les espaces du .Net, faux sinon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return boolean|bool
     */
    public function EtudiantPublieSurTousLesEspaces($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->EtudiantPublieSurTousLesEspaces($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
