<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Etablissement ServiceType
 * @subpackage Services
 */
class Etablissement extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EtablissementOrigineEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Nom de l'établissement d'origine de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function EtablissementOrigineEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->EtablissementOrigineEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
