<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Effacer ServiceType
 * @subpackage Services
 */
class Effacer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EffacerPhotoEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Efface la photo de l'étudiant de clé 'AEtudiant'.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return void|bool
     */
    public function EffacerPhotoEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->EffacerPhotoEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
