<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for EM ServiceType
 * @subpackage Services
 */
class EM extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EMailEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Email de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function EMailEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->EMailEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EMailsTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Email des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauChaines|bool
     */
    public function EMailsTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->EMailsTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\hp_\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
