<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cursus ServiceType
 * @subpackage Services
 */
class Cursus extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CursusAnterieurEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Cursus antérieur de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function CursusAnterieurEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->CursusAnterieurEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CursusAnterieurTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Cursus antérieur des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauChaines|bool
     */
    public function CursusAnterieurTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->CursusAnterieurTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\hp_\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
