<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Code ServiceType
 * @subpackage Services
 */
class Code extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CodeFiscalEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Code fiscal de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function CodeFiscalEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->CodeFiscalEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CodePostalEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Code postal de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function CodePostalEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->CodePostalEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CodeBaccalaureatDeNom
     * Meta information extracted from the WSDL
     * - documentation: Code du baccalauréat (ou équivalence) correspondant au nom 'ANom'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNom
     * @return string|bool
     */
    public function CodeBaccalaureatDeNom($aNom)
    {
        try {
            $this->setResult($this->getSoapClient()->CodeBaccalaureatDeNom($aNom));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CodeSpecialiteBacDeNom
     * Meta information extracted from the WSDL
     * - documentation: Code de la spécialité BAC correspondant au nom 'ANom'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNom
     * @return string|bool
     */
    public function CodeSpecialiteBacDeNom($aNom)
    {
        try {
            $this->setResult($this->getSoapClient()->CodeSpecialiteBacDeNom($aNom));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CodeDepartementDeNom
     * Meta information extracted from the WSDL
     * - documentation: Code du département correspondant au nom 'ANom'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNom
     * @return string|bool
     */
    public function CodeDepartementDeNom($aNom)
    {
        try {
            $this->setResult($this->getSoapClient()->CodeDepartementDeNom($aNom));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CodeTypeDernierDiplomeDeNom
     * Meta information extracted from the WSDL
     * - documentation: Code du type du dernier diplôme obtenu correspondant au nom 'ANom'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNom
     * @return string|bool
     */
    public function CodeTypeDernierDiplomeDeNom($aNom)
    {
        try {
            $this->setResult($this->getSoapClient()->CodeTypeDernierDiplomeDeNom($aNom));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
