<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Autre ServiceType
 * @subpackage Services
 */
class Autre extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AutreInformationEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Autre information de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function AutreInformationEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->AutreInformationEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
