<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Nombre ServiceType
 * @subpackage Services
 */
class Nombre extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NombreEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Nombre total d'étudiants dans la base
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return unsignedInt|bool
     */
    public function NombreEtudiants()
    {
        try {
            $this->setResult($this->getSoapClient()->NombreEtudiants());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return unsignedInt
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
