<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Modalite ServiceType
 * @subpackage Services
 */
class Modalite extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ModaliteDAdmissionEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Modalité d'admission de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function ModaliteDAdmissionEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->ModaliteDAdmissionEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
