<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Email ServiceType
 * @subpackage Services
 */
class Email extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EmailEtablissementOrigine
     * Meta information extracted from the WSDL
     * - documentation: E-mail de l'établissement d'origine de nom 'AEtablissement'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtablissement
     * @return string|bool
     */
    public function EmailEtablissementOrigine($aEtablissement)
    {
        try {
            $this->setResult($this->getSoapClient()->EmailEtablissementOrigine($aEtablissement));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
