<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Dates ServiceType
 * @subpackage Services
 */
class Dates extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DatesDeNaissancesTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Date de naissance des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauDates|bool
     */
    public function DatesDeNaissancesTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->DatesDeNaissancesTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatesInscriptionTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Date d'inscription des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauDates|bool
     */
    public function DatesInscriptionTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->DatesInscriptionTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatesAffectationEtudiantAPromotion
     * Meta information extracted from the WSDL
     * - documentation: Dates d'affectation de l'étudiant de clé 'AEtudiant' dans la promotion de clé 'APromotion'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPromotion
     * @return \hp_\THpSvcWTableauTypesIntervalles|bool
     */
    public function DatesAffectationEtudiantAPromotion($aEtudiant, $aPromotion)
    {
        try {
            $this->setResult($this->getSoapClient()->DatesAffectationEtudiantAPromotion($aEtudiant, $aPromotion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DatesAffectationEtudiantAuTDOption
     * Meta information extracted from the WSDL
     * - documentation: Dates d'affectation de l'étudiant de clé 'AEtudiant' dans le TD/option de clé 'ATDOption'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aTDOption
     * @return \hp_\THpSvcWTableauTypesIntervalles|bool
     */
    public function DatesAffectationEtudiantAuTDOption($aEtudiant, $aTDOption)
    {
        try {
            $this->setResult($this->getSoapClient()->DatesAffectationEtudiantAuTDOption($aEtudiant, $aTDOption));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\THpSvcWTableauDates|\hp_\THpSvcWTableauTypesIntervalles
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
