<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cles ServiceType
 * @subpackage Services
 */
class Cles extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * ClesEtudiantsValidesTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Tableau contenant toutes les clés valides du tableau de clés 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauClesEtudiants|bool
     */
    public function ClesEtudiantsValidesTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->ClesEtudiantsValidesTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ClesEtudiantsInvalidesTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Tableau contenant toutes les clés invalides du tableau de clés 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauClesEtudiants|bool
     */
    public function ClesEtudiantsInvalidesTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->ClesEtudiantsInvalidesTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ClesSecuriteSocialeTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Clé de sécurité sociale des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauChaines|bool
     */
    public function ClesSecuriteSocialeTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->ClesSecuriteSocialeTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\THpSvcWTableauChaines|\hp_\THpSvcWTableauClesEtudiants
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
