<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cle ServiceType
 * @subpackage Services
 */
class Cle extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CleEtudiantEstValide
     * Meta information extracted from the WSDL
     * - documentation: Vrai si la clé étudiant 'AEtudiant' est valide, faux sinon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return boolean|bool
     */
    public function CleEtudiantEstValide($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->CleEtudiantEstValide($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CleSecuriteSocialeEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Clé de sécurité sociale de l'étudiant de clé 'AEtudiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return string|bool
     */
    public function CleSecuriteSocialeEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->CleSecuriteSocialeEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
