<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Acceder ServiceType
 * @subpackage Services
 */
class Acceder extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * AccederEtudiantParNomPrenomDateDeNaissanceEtNumeroINE
     * Meta information extracted from the WSDL
     * - documentation: Clé de l'étudiant de nom 'ANom', de prénom 'APrenom', de date de naissance 'ADateDeNaissance' et de numéro INE 'ANumeroINE'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNom
     * @param string $aPrenom
     * @param string $aDateDeNaissance
     * @param string $aNumeroINE
     * @return THpSvcWCleEtudiant|bool
     */
    public function AccederEtudiantParNomPrenomDateDeNaissanceEtNumeroINE($aNom, $aPrenom, $aDateDeNaissance, $aNumeroINE)
    {
        try {
            $this->setResult($this->getSoapClient()->AccederEtudiantParNomPrenomDateDeNaissanceEtNumeroINE($aNom, $aPrenom, $aDateDeNaissance, $aNumeroINE));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AccederEtudiantsParNomPrenomEtDateDeNaissance
     * Meta information extracted from the WSDL
     * - documentation: Anciennement 'AccederEtudiantParNomPrenomEtDateDeNaissance'. Tableau des clés des étudiants de nom 'ANom', de prénom 'APrenom' et de date de naissance 'ADateDeNaissance'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNom
     * @param string $aPrenom
     * @param string $aDateDeNaissance
     * @return \hp_\THpSvcWTableauClesEtudiants|bool
     */
    public function AccederEtudiantsParNomPrenomEtDateDeNaissance($aNom, $aPrenom, $aDateDeNaissance)
    {
        try {
            $this->setResult($this->getSoapClient()->AccederEtudiantsParNomPrenomEtDateDeNaissance($aNom, $aPrenom, $aDateDeNaissance));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AccederEtudiantParIdentifiant
     * Meta information extracted from the WSDL
     * - documentation: Clé de l'étudiant d'identifiant 'AIdentifiant'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aIdentifiant
     * @return THpSvcWCleEtudiant|bool
     */
    public function AccederEtudiantParIdentifiant($aIdentifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->AccederEtudiantParIdentifiant($aIdentifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AccederEtudiantParNumeroDOrdre
     * Meta information extracted from the WSDL
     * - documentation: Clé de l'étudiant de numéro d'ordre 'ANumero'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNumero
     * @return THpSvcWCleEtudiant|bool
     */
    public function AccederEtudiantParNumeroDOrdre($aNumero)
    {
        try {
            $this->setResult($this->getSoapClient()->AccederEtudiantParNumeroDOrdre($aNumero));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AccederEtudiantParNumeroINE
     * Meta information extracted from the WSDL
     * - documentation: Clé de l'étudiant de numéro INE 'ANumero'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aNumero
     * @return THpSvcWCleEtudiant|bool
     */
    public function AccederEtudiantParNumeroINE($aNumero)
    {
        try {
            $this->setResult($this->getSoapClient()->AccederEtudiantParNumeroINE($aNumero));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return THpSvcWCleEtudiant|\hp_\THpSvcWTableauClesEtudiants
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
