<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Tous ServiceType
 * @subpackage Services
 */
class Tous extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TousLesEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés de tous les étudiants de la base
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \hp_\THpSvcWTableauClesEtudiants|bool
     */
    public function TousLesEtudiants()
    {
        try {
            $this->setResult($this->getSoapClient()->TousLesEtudiants());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TousLesEtablissementsOrigine
     * Meta information extracted from the WSDL
     * - documentation: Tableau des noms de tous les établissements d'origine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \hp_\THpSvcWTableauChaines|bool
     */
    public function TousLesEtablissementsOrigine()
    {
        try {
            $this->setResult($this->getSoapClient()->TousLesEtablissementsOrigine());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\THpSvcWTableauChaines|\hp_\THpSvcWTableauClesEtudiants
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
