<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for TDO ServiceType
 * @subpackage Services
 */
class TDO extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TDOptionsEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés des TD/options de l'étudiant de clé 'AEtudiant' à la date d'aujourd'hui
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return \hp_\THpSvcWTableauClesTDOptions|bool
     */
    public function TDOptionsEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->TDOptionsEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TDOptionsEtudiantALaDate
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés des TD/options de l'étudiant de clé 'AEtudiant' à la date 'ADate'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aDate
     * @return \hp_\THpSvcWTableauClesTDOptions|bool
     */
    public function TDOptionsEtudiantALaDate($aEtudiant, $aDate)
    {
        try {
            $this->setResult($this->getSoapClient()->TDOptionsEtudiantALaDate($aEtudiant, $aDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TDOptionsEtudiantEntre2Dates
     * Meta information extracted from the WSDL
     * - documentation: Clés des TD/options où l'étudiant de clé 'AEtudiant' a été inscrit au moins un jour entre 'ADateDebut' et 'ADateFin'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aDateDebut
     * @param string $aDateFin
     * @return \hp_\THpSvcWTableauClesTDOptions|bool
     */
    public function TDOptionsEtudiantEntre2Dates($aEtudiant, $aDateDebut, $aDateFin)
    {
        try {
            $this->setResult($this->getSoapClient()->TDOptionsEtudiantEntre2Dates($aEtudiant, $aDateDebut, $aDateFin));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\THpSvcWTableauClesTDOptions
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
