<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Le ServiceType
 * @subpackage Services
 */
class Le_1 extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LeTableauDEtudiantsSontRedoublants
     * Meta information extracted from the WSDL
     * - documentation: Tableau de booléens indiquant si les étudiants dont la clé est dans 'ATableau' sont redoublants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauBooleens|bool
     */
    public function LeTableauDEtudiantsSontRedoublants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->LeTableauDEtudiantsSontRedoublants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\THpSvcWTableauBooleens
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
