<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Identifiants ServiceType
 * @subpackage Services
 */
class Identifiants extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IdentifiantsTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: UID-Identifiant des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauChaines|bool
     */
    public function IdentifiantsTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->IdentifiantsTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IdentifiantsCASTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Identifiant CAS des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauChaines|bool
     */
    public function IdentifiantsCASTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->IdentifiantsCASTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * IdentifiantsConnexionTableauDEtudiants
     * Meta information extracted from the WSDL
     * - documentation: Identifiant de connexion des étudiants dont la clé est dans 'ATableau'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \hp_\THpSvcWTableauClesEtudiants $aTableau
     * @return \hp_\THpSvcWTableauChaines|bool
     */
    public function IdentifiantsConnexionTableauDEtudiants(\hp_\THpSvcWTableauClesEtudiants $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->IdentifiantsConnexionTableauDEtudiants($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \hp_\THpSvcWTableauChaines
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
