<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Est ServiceType
 * @subpackage Services
 */
class Est extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * EstDestinataireCourriersAbsencesEtudiant
     * Meta information extracted from the WSDL
     * - documentation: Vrai si l'étudiant est destinataire des courriers liés à la vie scolaire, faux sinon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @return boolean|bool
     */
    public function EstDestinataireCourriersAbsencesEtudiant($aEtudiant)
    {
        try {
            $this->setResult($this->getSoapClient()->EstDestinataireCourriersAbsencesEtudiant($aEtudiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
