<?php

namespace hp_;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enlever ServiceType
 * @subpackage Services
 */
class Enlever extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EnleverEtudiantDeLaPromotion
     * Meta information extracted from the WSDL
     * - documentation: Enleve l'étudiant de clé 'AEtudiant' de la promotion de clé 'APromotion' sur l'année
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPromotion
     * @return void|bool
     */
    public function EnleverEtudiantDeLaPromotion($aEtudiant, $aPromotion)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverEtudiantDeLaPromotion($aEtudiant, $aPromotion));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EnleverEtudiantDeLaPromotionALaDate
     * Meta information extracted from the WSDL
     * - documentation: Enleve l'étudiant de clé 'AEtudiant' de la promotion de clé 'APromotion' à partir de la date 'ADate'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aPromotion
     * @param string $aDate
     * @return void|bool
     */
    public function EnleverEtudiantDeLaPromotionALaDate($aEtudiant, $aPromotion, $aDate)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverEtudiantDeLaPromotionALaDate($aEtudiant, $aPromotion, $aDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverEtudiantDeTDOption
     * Meta information extracted from the WSDL
     * - documentation: Enleve l'étudiant de clé 'AEtudiant' du TD/Option de clé 'ATDOption' sur l'année. Rien ne se produit si l'étudiant n'a pas ce TD ou cette option
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aTDOption
     * @return void|bool
     */
    public function EnleverEtudiantDeTDOption($aEtudiant, $aTDOption)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverEtudiantDeTDOption($aEtudiant, $aTDOption));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnleverEtudiantDeTDOptionALaDate
     * Meta information extracted from the WSDL
     * - documentation: Enleve l'étudiant de clé 'AEtudiant' du TD/Option de clé 'ATDOption' à partir de la date 'ADate'. Rien ne se produit si l'étudiant n'a pas ce TD ou cette option
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aEtudiant
     * @param string $aTDOption
     * @param string $aDate
     * @return void|bool
     */
    public function EnleverEtudiantDeTDOptionALaDate($aEtudiant, $aTDOption, $aDate)
    {
        try {
            $this->setResult($this->getSoapClient()->EnleverEtudiantDeTDOptionALaDate($aEtudiant, $aTDOption, $aDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
