<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Record ServiceType
 * @subpackage Services
 */
class Record extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named recordCycleCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $string_1
     * @return string|bool
     */
    public function recordCycleCount($string_1)
    {
        try {
            $this->setResult($this->getSoapClient()->recordCycleCount($string_1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
