<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mobile ServiceType
 * @subpackage Services
 */
class Mobile extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named mobileMethod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $string_1
     * @param string $string_2
     * @param string $string_3
     * @return string|bool
     */
    public function mobileMethod($string_1, $string_2, $string_3)
    {
        try {
            $this->setResult($this->getSoapClient()->mobileMethod($string_1, $string_2, $string_3));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
