<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Parameters StructType
 * @subpackage Structs
 */
class Parameters extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNumber;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ParametersServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Parameters
     * @uses Parameters::setDisplayName()
     * @uses Parameters::setOrderType()
     * @uses Parameters::setOrderNumber()
     * @uses Parameters::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNumber
     * @param \StructType\ParametersServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $orderType = null, \StructType\Field $orderNumber = null, \StructType\ParametersServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setOrderType($orderType)
            ->setOrderNumber($orderNumber)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Parameters
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\Parameters
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return \StructType\Field|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param \StructType\Field $orderNumber
     * @return \StructType\Parameters
     */
    public function setOrderNumber(\StructType\Field $orderNumber = null)
    {
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ParametersServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ParametersServiceCommands $serviceCommands
     * @return \StructType\Parameters
     */
    public function setServiceCommands(\StructType\ParametersServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
