<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailSettings StructType
 * @subpackage Structs
 */
class MailSettings extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The To
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $To;
    /**
     * The Cc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Cc;
    /**
     * The Bcc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Bcc;
    /**
     * The Subject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Subject;
    /**
     * The Body
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Body;
    /**
     * The TemplateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TemplateID;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Format;
    /**
     * The ActivitySource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ActivitySource;
    /**
     * The ParentSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ParentSource;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MailSettingsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for MailSettings
     * @uses MailSettings::setDisplayName()
     * @uses MailSettings::setTo()
     * @uses MailSettings::setCc()
     * @uses MailSettings::setBcc()
     * @uses MailSettings::setSubject()
     * @uses MailSettings::setBody()
     * @uses MailSettings::setTemplateID()
     * @uses MailSettings::setFormat()
     * @uses MailSettings::setActivitySource()
     * @uses MailSettings::setParentSource()
     * @uses MailSettings::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $to
     * @param \StructType\Field $cc
     * @param \StructType\Field $bcc
     * @param \StructType\Field $subject
     * @param \StructType\Field $body
     * @param \StructType\Field $templateID
     * @param \StructType\Field $format
     * @param \StructType\Field $activitySource
     * @param \StructType\Field $parentSource
     * @param \StructType\MailSettingsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $to = null, \StructType\Field $cc = null, \StructType\Field $bcc = null, \StructType\Field $subject = null, \StructType\Field $body = null, \StructType\Field $templateID = null, \StructType\Field $format = null, \StructType\Field $activitySource = null, \StructType\Field $parentSource = null, \StructType\MailSettingsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setTo($to)
            ->setCc($cc)
            ->setBcc($bcc)
            ->setSubject($subject)
            ->setBody($body)
            ->setTemplateID($templateID)
            ->setFormat($format)
            ->setActivitySource($activitySource)
            ->setParentSource($parentSource)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\MailSettings
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get To value
     * @return \StructType\Field|null
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param \StructType\Field $to
     * @return \StructType\MailSettings
     */
    public function setTo(\StructType\Field $to = null)
    {
        $this->To = $to;
        return $this;
    }
    /**
     * Get Cc value
     * @return \StructType\Field|null
     */
    public function getCc()
    {
        return $this->Cc;
    }
    /**
     * Set Cc value
     * @param \StructType\Field $cc
     * @return \StructType\MailSettings
     */
    public function setCc(\StructType\Field $cc = null)
    {
        $this->Cc = $cc;
        return $this;
    }
    /**
     * Get Bcc value
     * @return \StructType\Field|null
     */
    public function getBcc()
    {
        return $this->Bcc;
    }
    /**
     * Set Bcc value
     * @param \StructType\Field $bcc
     * @return \StructType\MailSettings
     */
    public function setBcc(\StructType\Field $bcc = null)
    {
        $this->Bcc = $bcc;
        return $this;
    }
    /**
     * Get Subject value
     * @return \StructType\Field|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param \StructType\Field $subject
     * @return \StructType\MailSettings
     */
    public function setSubject(\StructType\Field $subject = null)
    {
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Body value
     * @return \StructType\Field|null
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param \StructType\Field $body
     * @return \StructType\MailSettings
     */
    public function setBody(\StructType\Field $body = null)
    {
        $this->Body = $body;
        return $this;
    }
    /**
     * Get TemplateID value
     * @return \StructType\Field|null
     */
    public function getTemplateID()
    {
        return $this->TemplateID;
    }
    /**
     * Set TemplateID value
     * @param \StructType\Field $templateID
     * @return \StructType\MailSettings
     */
    public function setTemplateID(\StructType\Field $templateID = null)
    {
        $this->TemplateID = $templateID;
        return $this;
    }
    /**
     * Get Format value
     * @return \StructType\Field|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param \StructType\Field $format
     * @return \StructType\MailSettings
     */
    public function setFormat(\StructType\Field $format = null)
    {
        $this->Format = $format;
        return $this;
    }
    /**
     * Get ActivitySource value
     * @return \StructType\Field|null
     */
    public function getActivitySource()
    {
        return $this->ActivitySource;
    }
    /**
     * Set ActivitySource value
     * @param \StructType\Field $activitySource
     * @return \StructType\MailSettings
     */
    public function setActivitySource(\StructType\Field $activitySource = null)
    {
        $this->ActivitySource = $activitySource;
        return $this;
    }
    /**
     * Get ParentSource value
     * @return \StructType\Field|null
     */
    public function getParentSource()
    {
        return $this->ParentSource;
    }
    /**
     * Set ParentSource value
     * @param \StructType\Field $parentSource
     * @return \StructType\MailSettings
     */
    public function setParentSource(\StructType\Field $parentSource = null)
    {
        $this->ParentSource = $parentSource;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\MailSettingsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\MailSettingsServiceCommands $serviceCommands
     * @return \StructType\MailSettings
     */
    public function setServiceCommands(\StructType\MailSettingsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
