<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Hp_\Hp_ClassMap::get(),
);
/**
 * Samples for Cle ServiceType
 */
$cle = new \Hp_\ServiceType\Hp_Cle($options);
/**
 * Sample call for CleFamilleEstValide operation/method
 */
if ($cle->CleFamilleEstValide($AFamille) !== false) {
    print_r($cle->getResult());
} else {
    print_r($cle->getLastError());
}
/**
 * Sample call for CleRubriqueEstValide operation/method
 */
if ($cle->CleRubriqueEstValide($ARubrique) !== false) {
    print_r($cle->getResult());
} else {
    print_r($cle->getLastError());
}
/**
 * Samples for Cles ServiceType
 */
$cles = new \Hp_\ServiceType\Hp_Cles($options);
/**
 * Sample call for ClesFamillesValidesTableauDeFamilles operation/method
 */
if ($cles->ClesFamillesValidesTableauDeFamilles(new \Hp_\StructType\Hp_THpSvcWTableauClesFamilles()) !== false) {
    print_r($cles->getResult());
} else {
    print_r($cles->getLastError());
}
/**
 * Sample call for ClesFamillesInvalidesTableauDeFamilles operation/method
 */
if ($cles->ClesFamillesInvalidesTableauDeFamilles(new \Hp_\StructType\Hp_THpSvcWTableauClesFamilles()) !== false) {
    print_r($cles->getResult());
} else {
    print_r($cles->getLastError());
}
/**
 * Sample call for ClesRubriquesValidesTableauDeRubriques operation/method
 */
if ($cles->ClesRubriquesValidesTableauDeRubriques(new \Hp_\StructType\Hp_THpSvcWTableauClesRubriques()) !== false) {
    print_r($cles->getResult());
} else {
    print_r($cles->getLastError());
}
/**
 * Sample call for ClesRubriquesInvalidesTableauDeRubriques operation/method
 */
if ($cles->ClesRubriquesInvalidesTableauDeRubriques(new \Hp_\StructType\Hp_THpSvcWTableauClesRubriques()) !== false) {
    print_r($cles->getResult());
} else {
    print_r($cles->getLastError());
}
/**
 * Samples for Est ServiceType
 */
$est = new \Hp_\ServiceType\Hp_Est($options);
/**
 * Sample call for EstUneFamilleARubriquesPredefinies operation/method
 */
if ($est->EstUneFamilleARubriquesPredefinies($AFamille) !== false) {
    print_r($est->getResult());
} else {
    print_r($est->getLastError());
}
/**
 * Sample call for EstUneFamilleARubriquesLibres operation/method
 */
if ($est->EstUneFamilleARubriquesLibres($AFamille) !== false) {
    print_r($est->getResult());
} else {
    print_r($est->getLastError());
}
/**
 * Samples for Restreindre ServiceType
 */
$restreindre = new \Hp_\ServiceType\Hp_Restreindre($options);
/**
 * Sample call for RestreindreTableauDeFamillesAuxFamillesARubriquesPredefinies
 * operation/method
 */
if ($restreindre->RestreindreTableauDeFamillesAuxFamillesARubriquesPredefinies(new \Hp_\StructType\Hp_THpSvcWTableauClesFamilles()) !== false) {
    print_r($restreindre->getResult());
} else {
    print_r($restreindre->getLastError());
}
/**
 * Sample call for RestreindreTableauDeFamillesAuxFamillesARubriquesLibres
 * operation/method
 */
if ($restreindre->RestreindreTableauDeFamillesAuxFamillesARubriquesLibres(new \Hp_\StructType\Hp_THpSvcWTableauClesFamilles()) !== false) {
    print_r($restreindre->getResult());
} else {
    print_r($restreindre->getLastError());
}
/**
 * Samples for Nombre ServiceType
 */
$nombre = new \Hp_\ServiceType\Hp_Nombre($options);
/**
 * Sample call for NombreFamillesDuGenre operation/method
 */
if ($nombre->NombreFamillesDuGenre($AGenre) !== false) {
    print_r($nombre->getResult());
} else {
    print_r($nombre->getLastError());
}
/**
 * Sample call for NombreRubriquesDeLaFamille operation/method
 */
if ($nombre->NombreRubriquesDeLaFamille($AFamille) !== false) {
    print_r($nombre->getResult());
} else {
    print_r($nombre->getLastError());
}
/**
 * Samples for Toutes ServiceType
 */
$toutes = new \Hp_\ServiceType\Hp_Toutes($options);
/**
 * Sample call for ToutesLesFamillesDuGenre operation/method
 */
if ($toutes->ToutesLesFamillesDuGenre($AGenre) !== false) {
    print_r($toutes->getResult());
} else {
    print_r($toutes->getLastError());
}
/**
 * Sample call for ToutesLesRubriquesDeLaFamille operation/method
 */
if ($toutes->ToutesLesRubriquesDeLaFamille($AFamille) !== false) {
    print_r($toutes->getResult());
} else {
    print_r($toutes->getLastError());
}
/**
 * Samples for Creer ServiceType
 */
$creer = new \Hp_\ServiceType\Hp_Creer($options);
/**
 * Sample call for CreerFamille operation/method
 */
if ($creer->CreerFamille($ALibelle, new \Hp_\StructType\Hp_THpSvcWTableauGenresFamille()) !== false) {
    print_r($creer->getResult());
} else {
    print_r($creer->getLastError());
}
/**
 * Sample call for CreerRubriqueDeFamille operation/method
 */
if ($creer->CreerRubriqueDeFamille($AFamille, $ALibelle) !== false) {
    print_r($creer->getResult());
} else {
    print_r($creer->getLastError());
}
/**
 * Sample call for CreerFamilleARubriquesLibres operation/method
 */
if ($creer->CreerFamilleARubriquesLibres($ALibelle, new \Hp_\StructType\Hp_THpSvcWTableauGenresFamille()) !== false) {
    print_r($creer->getResult());
} else {
    print_r($creer->getLastError());
}
/**
 * Samples for Supprimer ServiceType
 */
$supprimer = new \Hp_\ServiceType\Hp_Supprimer($options);
/**
 * Sample call for SupprimerFamille operation/method
 */
if ($supprimer->SupprimerFamille($AFamille) !== false) {
    print_r($supprimer->getResult());
} else {
    print_r($supprimer->getLastError());
}
/**
 * Sample call for SupprimerTableauDeFamilles operation/method
 */
if ($supprimer->SupprimerTableauDeFamilles(new \Hp_\StructType\Hp_THpSvcWTableauClesFamilles()) !== false) {
    print_r($supprimer->getResult());
} else {
    print_r($supprimer->getLastError());
}
/**
 * Sample call for SupprimerRubrique operation/method
 */
if ($supprimer->SupprimerRubrique($ARubrique) !== false) {
    print_r($supprimer->getResult());
} else {
    print_r($supprimer->getLastError());
}
/**
 * Sample call for SupprimerTableauDeRubriques operation/method
 */
if ($supprimer->SupprimerTableauDeRubriques(new \Hp_\StructType\Hp_THpSvcWTableauClesRubriques()) !== false) {
    print_r($supprimer->getResult());
} else {
    print_r($supprimer->getLastError());
}
/**
 * Samples for Familles ServiceType
 */
$familles = new \Hp_\ServiceType\Hp_Familles($options);
/**
 * Sample call for FamillesDeLibelle operation/method
 */
if ($familles->FamillesDeLibelle($ALibelle) !== false) {
    print_r($familles->getResult());
} else {
    print_r($familles->getLastError());
}
/**
 * Samples for Rubriques ServiceType
 */
$rubriques = new \Hp_\ServiceType\Hp_Rubriques($options);
/**
 * Sample call for RubriquesDeLaFamilleParLibelle operation/method
 */
if ($rubriques->RubriquesDeLaFamilleParLibelle($AFamille, $ALibelle) !== false) {
    print_r($rubriques->getResult());
} else {
    print_r($rubriques->getLastError());
}
/**
 * Samples for Libelle ServiceType
 */
$libelle = new \Hp_\ServiceType\Hp_Libelle($options);
/**
 * Sample call for LibelleFamille operation/method
 */
if ($libelle->LibelleFamille($AFamille) !== false) {
    print_r($libelle->getResult());
} else {
    print_r($libelle->getLastError());
}
/**
 * Sample call for LibelleRubrique operation/method
 */
if ($libelle->LibelleRubrique($ARubrique) !== false) {
    print_r($libelle->getResult());
} else {
    print_r($libelle->getLastError());
}
/**
 * Samples for Modifier ServiceType
 */
$modifier = new \Hp_\ServiceType\Hp_Modifier($options);
/**
 * Sample call for ModifierLibelleFamille operation/method
 */
if ($modifier->ModifierLibelleFamille($AFamille, $ALibelle) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierLibelleRubrique operation/method
 */
if ($modifier->ModifierLibelleRubrique($ARubrique, $ALibelle) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDeLaMatiereDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDeLaMatiereDeFamille($AFamille, $AMatiere, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDeLEnseignantDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDeLEnseignantDeFamille($AFamille, $AEnseignant, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDeLaPromotionDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDeLaPromotionDeFamille($AFamille, $APromotion, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDuTDOptionDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDuTDOptionDeFamille($AFamille, $ATDOption, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDuRegroupementDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDuRegroupementDeFamille($AFamille, $ARegroupement, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDeLEtudiantDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDeLEtudiantDeFamille($AFamille, $AEtudiant, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDeLaSalleDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDeLaSalleDeFamille($AFamille, $ASalle, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDuCursusDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDuCursusDeFamille($AFamille, $ACursus, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDuModuleDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDuModuleDeFamille($AFamille, $AModule, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDuCoursDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDuCoursDeFamille($AFamille, $ACours, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDeLAppariteurDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDeLAppariteurDeFamille($AFamille, $AAppariteur, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDuTypeDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDuTypeDeFamille($AFamille, $AType, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDeLEntrepriseDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDeLEntrepriseDeFamille($AFamille, $AEntreprise, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDuContactDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDuContactDeFamille($AFamille, $AContact, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDuStageDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDuStageDeFamille($AFamille, $AStage, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDeLAlternanceDeFamille operation/method
 */
if ($modifier->ModifierRubriqueLibreDeLAlternanceDeFamille($AFamille, $AAlternance, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDuCalendrierNotationDeFamille
 * operation/method
 */
if ($modifier->ModifierRubriqueLibreDuCalendrierNotationDeFamille($AFamille, $ACalendrierNotation, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Sample call for ModifierRubriqueLibreDePeriodeHorsCalendrierDeFamille
 * operation/method
 */
if ($modifier->ModifierRubriqueLibreDePeriodeHorsCalendrierDeFamille($AFamille, $APeriodeHorsCalendrier, $ARubriqueLibre) !== false) {
    print_r($modifier->getResult());
} else {
    print_r($modifier->getLastError());
}
/**
 * Samples for Libelles ServiceType
 */
$libelles = new \Hp_\ServiceType\Hp_Libelles($options);
/**
 * Sample call for LibellesTableauDeFamilles operation/method
 */
if ($libelles->LibellesTableauDeFamilles(new \Hp_\StructType\Hp_THpSvcWTableauClesFamilles()) !== false) {
    print_r($libelles->getResult());
} else {
    print_r($libelles->getLastError());
}
/**
 * Sample call for LibellesTableauDeRubriques operation/method
 */
if ($libelles->LibellesTableauDeRubriques(new \Hp_\StructType\Hp_THpSvcWTableauClesRubriques()) !== false) {
    print_r($libelles->getResult());
} else {
    print_r($libelles->getLastError());
}
/**
 * Samples for Genres ServiceType
 */
$genres = new \Hp_\ServiceType\Hp_Genres($options);
/**
 * Sample call for GenresFamille operation/method
 */
if ($genres->GenresFamille($AFamille) !== false) {
    print_r($genres->getResult());
} else {
    print_r($genres->getLastError());
}
/**
 * Samples for Ajouter ServiceType
 */
$ajouter = new \Hp_\ServiceType\Hp_Ajouter($options);
/**
 * Sample call for AjouterGenresFamille operation/method
 */
if ($ajouter->AjouterGenresFamille($AFamille, new \Hp_\StructType\Hp_THpSvcWTableauGenresFamille()) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueALaMatiere operation/method
 */
if ($ajouter->AjouterUneRubriqueALaMatiere($ARubrique, $AMatiere) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueALEnseignant operation/method
 */
if ($ajouter->AjouterUneRubriqueALEnseignant($ARubrique, $AEnseignant) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueALaPromotion operation/method
 */
if ($ajouter->AjouterUneRubriqueALaPromotion($ARubrique, $APromotion) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueAuTDOption operation/method
 */
if ($ajouter->AjouterUneRubriqueAuTDOption($ARubrique, $ATDOption) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueAuRegroupement operation/method
 */
if ($ajouter->AjouterUneRubriqueAuRegroupement($ARubrique, $ARegroupement) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueALEtudiant operation/method
 */
if ($ajouter->AjouterUneRubriqueALEtudiant($ARubrique, $AEtudiant) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueALaSalle operation/method
 */
if ($ajouter->AjouterUneRubriqueALaSalle($ARubrique, $ASalle) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueAuCursus operation/method
 */
if ($ajouter->AjouterUneRubriqueAuCursus($ARubrique, $ACursus) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueAuModule operation/method
 */
if ($ajouter->AjouterUneRubriqueAuModule($ARubrique, $AModule) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueAuCours operation/method
 */
if ($ajouter->AjouterUneRubriqueAuCours($ARubrique, $ACours) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueALAppariteur operation/method
 */
if ($ajouter->AjouterUneRubriqueALAppariteur($ARubrique, $AAppariteur) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueAuType operation/method
 */
if ($ajouter->AjouterUneRubriqueAuType($ARubrique, $AType) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueALEntreprise operation/method
 */
if ($ajouter->AjouterUneRubriqueALEntreprise($ARubrique, $AEntreprise) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueAuContact operation/method
 */
if ($ajouter->AjouterUneRubriqueAuContact($ARubrique, $AContact) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueAuStage operation/method
 */
if ($ajouter->AjouterUneRubriqueAuStage($ARubrique, $AStage) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueALAlternance operation/method
 */
if ($ajouter->AjouterUneRubriqueALAlternance($ARubrique, $AAlternance) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueAuCalendrierNotation operation/method
 */
if ($ajouter->AjouterUneRubriqueAuCalendrierNotation($ARubrique, $ACalendrierNotation) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Sample call for AjouterUneRubriqueALaPeriodeHorsCalendrier operation/method
 */
if ($ajouter->AjouterUneRubriqueALaPeriodeHorsCalendrier($ARubrique, $APeriodeHorsCalendrier) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
/**
 * Samples for Enlever ServiceType
 */
$enlever = new \Hp_\ServiceType\Hp_Enlever($options);
/**
 * Sample call for EnleverGenresFamille operation/method
 */
if ($enlever->EnleverGenresFamille($AFamille, new \Hp_\StructType\Hp_THpSvcWTableauGenresFamille()) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueALaMatiere operation/method
 */
if ($enlever->EnleverUneRubriqueALaMatiere($ARubrique, $AMatiere) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueALEnseignant operation/method
 */
if ($enlever->EnleverUneRubriqueALEnseignant($ARubrique, $AEnseignant) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueALaPromotion operation/method
 */
if ($enlever->EnleverUneRubriqueALaPromotion($ARubrique, $APromotion) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueAuTDOption operation/method
 */
if ($enlever->EnleverUneRubriqueAuTDOption($ARubrique, $ATDOption) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueAuRegroupement operation/method
 */
if ($enlever->EnleverUneRubriqueAuRegroupement($ARubrique, $ARegroupement) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueALEtudiant operation/method
 */
if ($enlever->EnleverUneRubriqueALEtudiant($ARubrique, $AEtudiant) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueALaSalle operation/method
 */
if ($enlever->EnleverUneRubriqueALaSalle($ARubrique, $ASalle) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueAuCursus operation/method
 */
if ($enlever->EnleverUneRubriqueAuCursus($ARubrique, $ACursus) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueAuModule operation/method
 */
if ($enlever->EnleverUneRubriqueAuModule($ARubrique, $AModule) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueAuCours operation/method
 */
if ($enlever->EnleverUneRubriqueAuCours($ARubrique, $ACours) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueALAppariteur operation/method
 */
if ($enlever->EnleverUneRubriqueALAppariteur($ARubrique, $AAppariteur) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueAuType operation/method
 */
if ($enlever->EnleverUneRubriqueAuType($ARubrique, $AType) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueALEntreprise operation/method
 */
if ($enlever->EnleverUneRubriqueALEntreprise($ARubrique, $AEntreprise) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueAuContact operation/method
 */
if ($enlever->EnleverUneRubriqueAuContact($ARubrique, $AContact) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueAuStage operation/method
 */
if ($enlever->EnleverUneRubriqueAuStage($ARubrique, $AStage) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueALAlternance operation/method
 */
if ($enlever->EnleverUneRubriqueALAlternance($ARubrique, $AAlternance) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueAuCalendrierNotation operation/method
 */
if ($enlever->EnleverUneRubriqueAuCalendrierNotation($ARubrique, $ACalendrierNotation) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Sample call for EnleverUneRubriqueALaPeriodeHorsCalendrier operation/method
 */
if ($enlever->EnleverUneRubriqueALaPeriodeHorsCalendrier($ARubrique, $APeriodeHorsCalendrier) !== false) {
    print_r($enlever->getResult());
} else {
    print_r($enlever->getLastError());
}
/**
 * Samples for Rubrique ServiceType
 */
$rubrique = new \Hp_\ServiceType\Hp_Rubrique($options);
/**
 * Sample call for RubriqueDeLaMatiereDeFamille operation/method
 */
if ($rubrique->RubriqueDeLaMatiereDeFamille($AFamille, $AMatiere) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDeLaMatiereDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDeLaMatiereDeFamille($AFamille, $AMatiere) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDeLEnseignantDeFamille operation/method
 */
if ($rubrique->RubriqueDeLEnseignantDeFamille($AFamille, $AEnseignant) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDeLEnseignantDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDeLEnseignantDeFamille($AFamille, $AEnseignant) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDeLaPromotionDeFamille operation/method
 */
if ($rubrique->RubriqueDeLaPromotionDeFamille($AFamille, $APromotion) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDeLaPromotionDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDeLaPromotionDeFamille($AFamille, $APromotion) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDuTDOptionDeFamille operation/method
 */
if ($rubrique->RubriqueDuTDOptionDeFamille($AFamille, $ATDOption) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDuTDOptionDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDuTDOptionDeFamille($AFamille, $ATDOption) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDuRegroupementDeFamille operation/method
 */
if ($rubrique->RubriqueDuRegroupementDeFamille($AFamille, $ARegroupement) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDuRegroupementDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDuRegroupementDeFamille($AFamille, $ARegroupement) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDeLEtudiantDeFamille operation/method
 */
if ($rubrique->RubriqueDeLEtudiantDeFamille($AFamille, $AEtudiant) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDeLEtudiantDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDeLEtudiantDeFamille($AFamille, $AEtudiant) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDeLaSalleDeFamille operation/method
 */
if ($rubrique->RubriqueDeLaSalleDeFamille($AFamille, $ASalle) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDeLaSalleDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDeLaSalleDeFamille($AFamille, $ASalle) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDuCursusDeFamille operation/method
 */
if ($rubrique->RubriqueDuCursusDeFamille($AFamille, $ACursus) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDuCursusDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDuCursusDeFamille($AFamille, $ACursus) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDuModuleDeFamille operation/method
 */
if ($rubrique->RubriqueDuModuleDeFamille($AFamille, $AModule) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDuModuleDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDuModuleDeFamille($AFamille, $AModule) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDuCoursDeFamille operation/method
 */
if ($rubrique->RubriqueDuCoursDeFamille($AFamille, $ACours) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDuCoursDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDuCoursDeFamille($AFamille, $ACours) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDeLAppariteurDeFamille operation/method
 */
if ($rubrique->RubriqueDeLAppariteurDeFamille($AFamille, $AAppariteur) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDeLAppariteurDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDeLAppariteurDeFamille($AFamille, $AAppariteur) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDuTypeDeFamille operation/method
 */
if ($rubrique->RubriqueDuTypeDeFamille($AFamille, $AType) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDuTypeDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDuTypeDeFamille($AFamille, $AType) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDEntrepriseDeFamille operation/method
 */
if ($rubrique->RubriqueDEntrepriseDeFamille($AFamille, $AEntreprise) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDeLEntrepriseDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDeLEntrepriseDeFamille($AFamille, $AEntreprise) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDuContactDeFamille operation/method
 */
if ($rubrique->RubriqueDuContactDeFamille($AFamille, $AContact) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDuContactDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDuContactDeFamille($AFamille, $AContact) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDuStageDeFamille operation/method
 */
if ($rubrique->RubriqueDuStageDeFamille($AFamille, $AStage) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDuStageDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDuStageDeFamille($AFamille, $AStage) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDeLAlternanceDeFamille operation/method
 */
if ($rubrique->RubriqueDeLAlternanceDeFamille($AFamille, $AAlternance) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDeLAlternanceDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDeLAlternanceDeFamille($AFamille, $AAlternance) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDuCalendrierNotationDeFamille operation/method
 */
if ($rubrique->RubriqueDuCalendrierNotationDeFamille($AFamille, $ACalendrierNotation) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueDePeriodeHorsCalendrierDeFamille operation/method
 */
if ($rubrique->RubriqueDePeriodeHorsCalendrierDeFamille($AFamille, $APeriodeHorsCalendrier) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDuCalendrierNotationDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDuCalendrierNotationDeFamille($AFamille, $ACalendrierNotation) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Sample call for RubriqueLibreDePeriodeHorsCalendrierDeFamille operation/method
 */
if ($rubrique->RubriqueLibreDePeriodeHorsCalendrierDeFamille($AFamille, $APeriodeHorsCalendrier) !== false) {
    print_r($rubrique->getResult());
} else {
    print_r($rubrique->getLastError());
}
/**
 * Samples for Trier ServiceType
 */
$trier = new \Hp_\ServiceType\Hp_Trier($options);
/**
 * Sample call for TrierTableauDeFamillesParCle operation/method
 */
if ($trier->TrierTableauDeFamillesParCle(new \Hp_\StructType\Hp_THpSvcWTableauClesFamilles()) !== false) {
    print_r($trier->getResult());
} else {
    print_r($trier->getLastError());
}
/**
 * Sample call for TrierTableauDeFamillesParLibelle operation/method
 */
if ($trier->TrierTableauDeFamillesParLibelle(new \Hp_\StructType\Hp_THpSvcWTableauClesFamilles()) !== false) {
    print_r($trier->getResult());
} else {
    print_r($trier->getLastError());
}
/**
 * Sample call for TrierTableauDeRubriquesParCle operation/method
 */
if ($trier->TrierTableauDeRubriquesParCle(new \Hp_\StructType\Hp_THpSvcWTableauClesRubriques()) !== false) {
    print_r($trier->getResult());
} else {
    print_r($trier->getLastError());
}
/**
 * Sample call for TrierTableauDeRubriquesParLibelle operation/method
 */
if ($trier->TrierTableauDeRubriquesParLibelle(new \Hp_\StructType\Hp_THpSvcWTableauClesRubriques()) !== false) {
    print_r($trier->getResult());
} else {
    print_r($trier->getLastError());
}
