<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Trier ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Trier extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TrierTableauDeFamillesParCle
     * Meta information extracted from the WSDL
     * - documentation: Trie le tableau 'ATableau' suivant la clé des familles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|bool
     */
    public function TrierTableauDeFamillesParCle(\Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->TrierTableauDeFamillesParCle($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TrierTableauDeFamillesParLibelle
     * Meta information extracted from the WSDL
     * - documentation: Trie le tableau 'ATableau' suivant le libellé des familles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|bool
     */
    public function TrierTableauDeFamillesParLibelle(\Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->TrierTableauDeFamillesParLibelle($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TrierTableauDeRubriquesParCle
     * Meta information extracted from the WSDL
     * - documentation: Trie le tableau 'ATableau' suivant la clé des rubriques
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function TrierTableauDeRubriquesParCle(\Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->TrierTableauDeRubriquesParCle($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TrierTableauDeRubriquesParLibelle
     * Meta information extracted from the WSDL
     * - documentation: Trie le tableau 'ATableau' suivant le libellé des rubriques
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function TrierTableauDeRubriquesParLibelle(\Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->TrierTableauDeRubriquesParLibelle($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|\Hp_\StructType\Hp_THpSvcWTableauClesRubriques
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
