<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Toutes ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Toutes extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ToutesLesFamillesDuGenre
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés de toutes les familles du genre 'AGenre' de la base
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aGenre
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|bool
     */
    public function ToutesLesFamillesDuGenre($aGenre)
    {
        try {
            $this->setResult($this->getSoapClient()->ToutesLesFamillesDuGenre($aGenre));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ToutesLesRubriquesDeLaFamille
     * Meta information extracted from the WSDL
     * - documentation: Tableau des clés de toutes les rubriques de la famille 'AFamille' de la base. Renvoie une exception si la famille est une famille à rubriques libres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesRubriques|bool
     */
    public function ToutesLesRubriquesDeLaFamille($aFamille)
    {
        try {
            $this->setResult($this->getSoapClient()->ToutesLesRubriquesDeLaFamille($aFamille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|\Hp_\StructType\Hp_THpSvcWTableauClesRubriques
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
