<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Supprimer ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Supprimer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SupprimerFamille
     * Meta information extracted from the WSDL
     * - documentation: Supprime la famille de clé 'AFamille'. Attention ! pas de suppression des familles utilisées par les utilisateurs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aFamille
     * @return void|bool
     */
    public function SupprimerFamille($aFamille)
    {
        try {
            $this->setResult($this->getSoapClient()->SupprimerFamille($aFamille));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SupprimerTableauDeFamilles
     * Meta information extracted from the WSDL
     * - documentation: Supprime les familles dont la clé est dans 'ATableau'. Attention ! pas de suppression des familles utilisées par les utilisateurs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau
     * @return void|bool
     */
    public function SupprimerTableauDeFamilles(\Hp_\StructType\Hp_THpSvcWTableauClesFamilles $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->SupprimerTableauDeFamilles($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SupprimerRubrique
     * Meta information extracted from the WSDL
     * - documentation: Supprime la rubrique de clé 'ARubrique'. Attention ! pas de suppression des rubriques utilisées par les utilisateurs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aRubrique
     * @return void|bool
     */
    public function SupprimerRubrique($aRubrique)
    {
        try {
            $this->setResult($this->getSoapClient()->SupprimerRubrique($aRubrique));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SupprimerTableauDeRubriques
     * Meta information extracted from the WSDL
     * - documentation: Supprime les rubriques dont la clé est dans 'ATableau'. Attention ! pas de suppression des rubriques utilisées par les utilisateurs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau
     * @return void|bool
     */
    public function SupprimerTableauDeRubriques(\Hp_\StructType\Hp_THpSvcWTableauClesRubriques $aTableau)
    {
        try {
            $this->setResult($this->getSoapClient()->SupprimerTableauDeRubriques($aTableau));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
