<?php

namespace Hp_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Familles ServiceType
 * @package Hp_
 * @subpackage Services
 */
class Hp_Familles extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FamillesDeLibelle
     * Meta information extracted from the WSDL
     * - documentation: Clés des familles de libellé 'ALibelle'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $aLibelle
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles|bool
     */
    public function FamillesDeLibelle($aLibelle)
    {
        try {
            $this->setResult($this->getSoapClient()->FamillesDeLibelle($aLibelle));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Hp_\StructType\Hp_THpSvcWTableauClesFamilles
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
